/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Date;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;

public class JhlStatus
implements ISVNStatus {
    protected Status _s;
    private SVNRevision.Number lastChangedRevision;
    private String lastChangedAuthor;
    private Date lastChangedDate;

    public JhlStatus(Status status) {
        this._s = status;
    }

    public SVNUrl getUrl() {
        try {
            String urlString = this.getUrlString();
            return urlString != null ? new SVNUrl(urlString) : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getUrlString() {
        return this._s.getUrl();
    }

    public SVNRevision.Number getLastChangedRevision() {
        if (this.lastChangedRevision != null) {
            return this.lastChangedRevision;
        }
        if (this._s.getReposLastCmtAuthor() == null) {
            return JhlConverter.convertRevisionNumber(this._s.getLastChangedRevisionNumber());
        }
        if (this._s.getReposLastCmtRevisionNumber() == 0L) {
            return null;
        }
        return JhlConverter.convertRevisionNumber(this._s.getReposLastCmtRevisionNumber());
    }

    public SVNRevision.Number getReposLastChangedRevision() {
        return JhlConverter.convertRevisionNumber(this._s.getReposLastCmtRevisionNumber());
    }

    public Date getLastChangedDate() {
        if (this.lastChangedDate != null) {
            return this.lastChangedDate;
        }
        if (this._s.getReposLastCmtAuthor() == null) {
            return this._s.getLastChangedDate();
        }
        return this._s.getReposLastCmtDate();
    }

    public String getLastCommitAuthor() {
        if (this.lastChangedAuthor != null) {
            return this.lastChangedAuthor;
        }
        if (this._s.getReposLastCmtAuthor() == null) {
            return this._s.getLastCommitAuthor();
        }
        return this._s.getReposLastCmtAuthor();
    }

    public SVNStatusKind getTextStatus() {
        return JhlConverter.convertStatusKind(this._s.getTextStatus());
    }

    public SVNStatusKind getPropStatus() {
        return JhlConverter.convertStatusKind(this._s.getPropStatus());
    }

    public SVNRevision.Number getRevision() {
        return JhlConverter.convertRevisionNumber(this._s.getRevisionNumber());
    }

    public boolean isCopied() {
        return this._s.isCopied();
    }

    public boolean isWcLocked() {
        return this._s.isLocked();
    }

    public boolean isSwitched() {
        return this._s.isSwitched();
    }

    public String getPath() {
        return this._s.getPath();
    }

    public File getFile() {
        return new File(this.getPath()).getAbsoluteFile();
    }

    public SVNNodeKind getNodeKind() {
        SVNNodeKind nodeKind = this._s.getReposLastCmtAuthor() == null ? JhlConverter.convertNodeKind(this._s.getNodeKind()) : JhlConverter.convertNodeKind(this._s.getReposKind());
        return nodeKind;
    }

    public SVNUrl getUrlCopiedFrom() {
        try {
            String url = this._s.getUrlCopiedFrom();
            return url != null ? new SVNUrl(url) : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public SVNStatusKind getRepositoryTextStatus() {
        return JhlConverter.convertStatusKind(this._s.getRepositoryTextStatus());
    }

    public SVNStatusKind getRepositoryPropStatus() {
        return JhlConverter.convertStatusKind(this._s.getRepositoryPropStatus());
    }

    public String toString() {
        return this.getPath() + " " + this.getTextStatus().toString();
    }

    public File getConflictNew() {
        String path = this._s.getConflictNew();
        return path != null ? new File(this.getFile().getParent(), path).getAbsoluteFile() : null;
    }

    public File getConflictOld() {
        String path = this._s.getConflictOld();
        return path != null ? new File(this.getFile().getParent(), path).getAbsoluteFile() : null;
    }

    public File getConflictWorking() {
        String path = this._s.getConflictWorking();
        return path != null ? new File(this.getFile().getParent(), path).getAbsoluteFile() : null;
    }

    public Date getLockCreationDate() {
        return this._s.getLockCreationDate();
    }

    public String getLockOwner() {
        return this._s.getLockOwner();
    }

    public String getLockComment() {
        return this._s.getLockComment();
    }

    public void updateFromInfo(ISVNInfo info) {
        this.lastChangedRevision = info.getLastChangedRevision();
        this.lastChangedAuthor = info.getLastCommitAuthor();
        this.lastChangedDate = info.getLastChangedDate();
    }

    public void updateFromStatus(JhlStatus info) {
        this.lastChangedRevision = info.getLastChangedRevision();
        this.lastChangedAuthor = info.getLastCommitAuthor();
        this.lastChangedDate = info.getLastChangedDate();
    }

    public static class JhlStatusExternal
    extends JhlStatus {
        private String url;

        public JhlStatusExternal(JhlStatus status) {
            this(status, null);
        }

        public JhlStatusExternal(JhlStatus status, String url) {
            super(status._s);
            this.url = url;
        }

        public SVNStatusKind getTextStatus() {
            return SVNStatusKind.EXTERNAL;
        }

        public String getUrlString() {
            return this.url != null ? this.url : super.getUrlString();
        }
    }
}

