﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/18
 * Time: 14:48
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using EWatch.Models;
using EWatch.Utils;

namespace EWatchView
{
	/// <summary>
	/// Description of Receiver.
	/// </summary>
	public class Receiver : IDisposable
	{
		private bool stopRunning;
		private Thread listener;
		private MainForm form;
		private int portNumber;

		public Receiver(int portNumber, MainForm form)
		{
			this.portNumber = portNumber;
			this.form = form;
			stopRunning = false;
			listener = new Thread(new ThreadStart(ListenThread));
			listener.Start();
		}
		
		public void Dispose()
		{
			stopRunning = true;
			listener.Join();
		}

		private void ListenThread()
		{
			try {
				UdpClient udpListener = new UdpClient(portNumber);
				udpListener.Client.ReceiveTimeout = 1000;
/*
				udpListener.Client.SetSocketOption(SocketOptionLevel.IPv6,
				                                   SocketOptionName.IPv6Only, 0);
*/
				byte[] receiveData;
				
				while(!stopRunning){
					try {
						IPEndPoint endPoint = new IPEndPoint(IPAddress.IPv6Any, 0);
						receiveData = udpListener.Receive(ref endPoint);
						string data = Encoding.UTF8.GetString(receiveData);
						HandleLog(data);
					}
					catch(SocketException) {
						continue;
					}
					catch(Exception) {
					}
				}
			}
			catch(Exception) {
			}
		}
		
		private void HandleLog(string data)
		{
			LogData logData = (LogData)JsonUtil.StringToObject(data, typeof(LogData));
			form.AddLogData(logData);
		}
	}
}
