﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/18
 * Time: 11:37
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using EWatch.Models;

namespace EWatchView
{
	/// <summary>
	/// Description of MainForm.
	/// </summary>
	public partial class MainForm : Form
	{
		private const int LISTMAX = 1000;
		private Font _font;
		private Receiver receiver;
		private int hilightIndex;
		private bool hilightFlag;
		private Configuration config;
		
		private delegate void AddItemDelegate(LogData data);
		
		public MainForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
			int a = Convert.ToInt32("ff", 16);
			config = Configuration.Load();
			_font = new Font(config.FontName, config.FontSize);
			hilightIndex = 0;
			listBox1.ItemHeight = _font.Height * 2;
			receiver = new Receiver(config.ListenPort, this);
			timer1.Interval = 500;
			timer1.Start();
		}
		
		void ListBox1DrawItem(object sender, DrawItemEventArgs e)
		{
			if(e.Index >= 0){
				LogData data = (LogData)listBox1.Items[e.Index];
				DisplayLogData(data, e.Graphics, e.Bounds, e.State==DrawItemState.Selected, false);
			}
		}
		
		private void DisplayLogData(LogData data, Graphics g, Rectangle rect, bool selected, bool hilight)
		{
			Brush brush = hilight ? new SolidBrush(Color.FromArgb(config.HilightColorInt)) : Brushes.Black;
			Brush bgBrush = new SolidBrush(listBox1.BackColor);
			g.FillRectangle(bgBrush, rect);
			Rectangle rect1 = rect;
			Rectangle rect2 = rect;
			rect1.Height = _font.Height;
			rect2.Y = rect1.Bottom;
			rect2.Height = _font.Height;
			g.DrawString(string.Format("{0} [{1}]", data.TimeStamp.Value.ToString("yyyy-MM-dd HH:mm:ss"), data.HostName),
			             _font, brush, rect1);
			g.DrawString(data.Message, _font, brush, rect2);
		}
		
		public void AddLogData(LogData data)
		{
			AddItemDelegate method = new AddItemDelegate(AddItem);
			method(data);
		}
		
		private void AddItem(LogData data)
		{
			if(listBox1.Items.Count+1 > LISTMAX){
				listBox1.Items.RemoveAt(0);
				if(hilightIndex > 0) hilightIndex--;
			}
			listBox1.Items.Add(data);
			listBox1.TopIndex = listBox1.Items.Count - listBox1.Height / listBox1.ItemHeight;
		}
		
		
		void MainFormFormClosed(object sender, FormClosedEventArgs e)
		{
			receiver.Dispose();
		}
		
		void Timer1Tick(object sender, EventArgs e)
		{
			DateTime baseTime = DateTime.Now.AddSeconds(-config.HilightSeconds);
			for(int index=hilightIndex; index < listBox1.Items.Count; index++){
				LogData data = (LogData)listBox1.Items[index];
				bool selected = listBox1.SelectedIndex == index;
				if(data.TimeStamp.Value < baseTime){
					DisplayLogData(data, listBox1.CreateGraphics(), listBox1.GetItemRectangle(index), selected, false);
					hilightIndex++;
				}
				else{
					DisplayLogData(data, listBox1.CreateGraphics(), listBox1.GetItemRectangle(index), selected, hilightFlag);
				}
			}
			hilightFlag = !hilightFlag;
		}
		
		void ListBox1Resize(object sender, EventArgs e)
		{
			ListBox listbox = (ListBox)sender;
			object[] items = new object[listbox.Items.Count];
			listbox.Items.CopyTo(items,0);
			listbox.BeginUpdate();
			listbox.Items.Clear();
			listbox.Items.AddRange(items);
			listbox.EndUpdate();
		}
		
		void ToolStripButton1Click(object sender, EventArgs e)
		{
			FormSetting form = new FormSetting();
			form.SetData(config);
			if(form.ShowDialog() == DialogResult.OK){
				form.GetData(config);
				config.Save();
			}
		}
	}
}
