﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/21
 * Time: 17:44
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Drawing;
using System.Windows.Forms;
using EWatch.Utils;

namespace EWatchView
{
	/// <summary>
	/// Description of FormSetting.
	/// </summary>
	public partial class FormSetting : Form
	{
		private string FontName {
			get {
				string[] array = textBoxFont.Text.Split(new char[]{ ',' });
				if(array.Length == 2){
					return array[0].Trim();
				}
				return string.Empty;
			}
		}
		private int FontSize {
			get {
				string[] array = textBoxFont.Text.Split(new char[]{ ',' });
				if(array.Length == 2){
					int val = 0;
					int.TryParse(array[1], out val);
					return val;
				}
				return 0;
			}
		}
		
		public FormSetting()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
		}
		
		void ButtonFontSelectClick(object sender, EventArgs e)
		{
			if(fontDialog1.ShowDialog() == DialogResult.OK){
				string font = string.Format("{0},{1}",
				                            fontDialog1.Font.Name,
				                            fontDialog1.Font.Size);
				textBoxFont.Text = font;
			}
		}
		
		void ButtonColorSelectClick(object sender, EventArgs e)
		{
			if(colorDialog1.ShowDialog() == DialogResult.OK){
				textBoxColorSample.ForeColor = colorDialog1.Color;
				textBoxColorSample.Text = "#"+colorDialog1.Color.ToArgb().ToString("X8");
			}
		}
		
		void ButtonOKClick(object sender, EventArgs e)
		{
			DialogResult = DialogResult.OK;
			Close();
		}
		
		public void SetData(Configuration config)
		{
			textBoxListenPort.Text = config.ListenPort.ToString();
			textBoxFont.Text = string.Format("{0},{1}", config.FontName, config.FontSize);
			textBoxColorSample.Text = config.HilightColor;
			textBoxColorSample.ForeColor = Color.FromArgb(config.HilightColorInt);
			textBoxHilightTime.Text = config.HilightSeconds.ToString();
		}
		
		public void GetData(Configuration config)
		{
			int listenPort = 0;
			if(int.TryParse(textBoxListenPort.Text, out listenPort)){
				config.ListenPort = listenPort;
			}
			config.FontName = FontName;
			config.FontSize = FontSize;
			config.HilightColor = textBoxColorSample.Text;
			int sec = 0;
			if(int.TryParse(textBoxHilightTime.Text, out sec)){
				config.HilightSeconds = sec;
			}
		}
	}
}
