﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/21
 * Time: 14:14
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.IO;
using System.Reflection;
using System.Windows.Forms;
using EWatch.Utils;

namespace EWatchView
{
	/// <summary>
	/// Description of Configration.
	/// </summary>
	public class Configuration
	{
		public int ListenPort { get; set; }
		public string FontName { get; set; }
		public int FontSize { get; set; }
		public int HilightSeconds { get; set; }
		public string HilightColor { get; set; }
		public int HilightColorInt {
			get {
				if(!Util.IsNullOrEmpty(HilightColor)){
					if(HilightColor.StartsWith("#")){
						string c = HilightColor.Replace("#", "");
						return Convert.ToInt32(HilightColor.Replace("#", ""), 16);
					}
				}
				return 0;
			}
		}
		
		public Configuration()
		{
			ListenPort = 31300;
			FontName = "MS UI Gothic";
			FontSize = 16;
			HilightSeconds = 60;
			HilightColor = "#FFC00000";
		}
		
		private static string GetPath()
		{
			return Path.Combine(
				Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location),
				"EWatchView.config.json");
		}
		
		public static Configuration Load()
		{
			try {
				using(StreamReader sr = new StreamReader(new FileStream(GetPath(), FileMode.Open, FileAccess.Read, FileShare.ReadWrite))){
					return (Configuration)JsonUtil.StringToObject(sr.ReadToEnd(), typeof(Configuration));
				}
			}
			catch(Exception){
				return new Configuration();
			}
		}
		
		public void Save()
		{
			try {
				using(StreamWriter sw = new StreamWriter(new FileStream(GetPath(), FileMode.OpenOrCreate, FileAccess.Write, FileShare.None))){
					sw.Write(JsonUtil.ObjectToString(this));
				}
			}
			catch(Exception){
				MessageBox.Show("Save failed.");
			}
		}
	}
}
