﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/11
 * Time: 12:44
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using EWatch.Actions;
using EWatch.Models.Configurations;
using EWatch.Utils;

namespace EWatchUI
{
	/// <summary>
	/// Description of FormRuleEdit.
	/// </summary>
	public partial class FormRuleEdit : Form
	{
		public WatchType Type { get; set; }
		public string Target { get; set; }
		public string[] TargetValues { get; set; }
		public ActionTable Table { get; set; }
		
		private List<BaseAction> _actions;
		
		public FormRuleEdit()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
		}
		
		
		
		void FormRuleEditLoad(object sender, EventArgs e)
		{
			switch (Type) {
				case WatchType.EventLog:
					SetDataForEventLog();
					break;
				case WatchType.File:
					SetDataForFile();
					break;
				case WatchType.Syslog:
					SetDataForSyslog();
					break;
				default:
					throw new Exception("Invalid value for WatchType");
			}
			if(Table == null){
				Table = new ActionTable();
				comboBoxTarget.SelectedIndex = 0;
			}
			if(!Util.IsNullOrEmpty(Table.Actions)){
				_actions = new List<BaseAction>(Table.Actions);
			}
			else{
				_actions = new List<BaseAction>();
			}
			SetActionList();
		}
		
		private void SetActionList()
		{
			listViewAction.Items.Clear();
			if(!Util.IsNullOrEmpty(_actions)){
				foreach(BaseAction action in _actions){
					Dictionary<string,object> actionProperties = action.GetProperties();
					StringBuilder param = new StringBuilder();
					foreach(string name in actionProperties.Keys){
						param.AppendFormat("{0}={1} ", name, actionProperties[name]);
					}
					ListViewItem item = new ListViewItem(action.GetName());
					item.SubItems.Add(param.ToString().Trim());
					listViewAction.Items.Add(item);
				}
				listViewAction.Columns[1].Width = -1;
			}
		}
		
		private void SetDataForEventLog()
		{
			comboBoxTarget.Items.Clear();
			comboBoxTarget.Items.Add(EventLogTypeEnum.Application.ToString());
			comboBoxTarget.Items.Add(EventLogTypeEnum.System.ToString());
			buttonRef.Visible = false;
			
			comboBoxLogLevel.Items.Clear();
			comboBoxLogLevel.Items.Add(string.Empty);
			comboBoxLogLevel.Items.Add("E");
			comboBoxLogLevel.Items.Add("W");
			comboBoxLogLevel.Items.Add("I");
			comboBoxLogLevel.Enabled = true;
			textBoxSource.Enabled = true;
			textBoxEventID.Enabled = true;

			if(Table != null){
				comboBoxTarget.Text = Target;
				comboBoxLogLevel.Text = Table.LogLevel;
				textBoxSource.Text = Table.EventSource;
				textBoxEventID.Text = Table.EventId != null ? Table.EventId.ToString() : null;
				textBoxHostname.Text = Table.HostName;
				textBoxMatch.Text = Table.MatchPattern;
				textBoxIgnore.Text = Table.IgnorePattern;
			}
		}
		
		private void SetDataForFile()
		{
			comboBoxTarget.Items.Clear();
			comboBoxTarget.Items.AddRange(TargetValues);
			buttonRef.Visible = true;
			
			comboBoxLogLevel.Enabled = false;
			textBoxSource.Enabled = false;
			textBoxEventID.Enabled = false;
			
			if(Table != null){
				comboBoxTarget.Text = Target;
				textBoxHostname.Text = Table.HostName;
				textBoxMatch.Text = Table.MatchPattern;
				textBoxIgnore.Text = Table.IgnorePattern;
			}
		}
		
		private void SetDataForSyslog()
		{
			comboBoxTarget.Items.Clear();
			comboBoxTarget.Items.AddRange(TargetValues);
			buttonRef.Visible = false;
			
			comboBoxLogLevel.Enabled = false;
			textBoxSource.Enabled = false;
			textBoxEventID.Enabled = false;
			
			if(Table != null){
				comboBoxTarget.Text = Target;
				textBoxHostname.Text = Table.HostName;
				textBoxMatch.Text = Table.MatchPattern;
				textBoxIgnore.Text = Table.IgnorePattern;
			}
		}
		
		void ButtonOKClick(object sender, EventArgs e)
		{
			GetData();
			DialogResult = DialogResult.OK;
			Close();
		}
		
		private void GetData()
		{
			Target = comboBoxTarget.Text;
			if(comboBoxLogLevel.Enabled){
				Table.LogLevel = comboBoxLogLevel.Text;
			}
			if(textBoxSource.Enabled){
				Table.EventSource = textBoxSource.Text;
			}
			if(textBoxEventID.Enabled){
				Table.EventId = Util.StringToInt(textBoxEventID.Text);
			}
			Table.HostName = textBoxHostname.Text;
			Table.MatchPattern = textBoxMatch.Text;
			Table.IgnorePattern = textBoxIgnore.Text;
			Table.Actions = _actions;
		}
		
		void ButtonAddClick(object sender, EventArgs e)
		{
			FormActionEdit form = new FormActionEdit();
			if(form.ShowDialog() == DialogResult.OK){
				_actions.Add(form.Action);
				SetActionList();
			}
		}
		
		void ButtonEditClick(object sender, EventArgs e)
		{
			if(listViewAction.SelectedItems.Count == 1){
				FormActionEdit form = new FormActionEdit();
				int index = listViewAction.SelectedItems[0].Index;
				form.Action = _actions[index];
				if(form.ShowDialog() == DialogResult.OK){
					_actions.RemoveAt(index);
					_actions.Insert(index, form.Action);
					SetActionList();
				}
			}
		}
		
		void ButtonDeleteClick(object sender, EventArgs e)
		{
			if(listViewAction.SelectedItems.Count > 0){
				for(int index=listViewAction.SelectedItems.Count-1; index>=0; index--){
					ListViewItem item = listViewAction.SelectedItems[index];
					_actions.RemoveAt(item.Index);
				}
				SetActionList();
			}
		}
		
		void ListViewActionDoubleClick(object sender, EventArgs e)
		{
			ButtonEditClick(sender, e);
		}
		
		void ButtonRefClick(object sender, EventArgs e)
		{
			OpenFileDialog dialog = new OpenFileDialog();
			dialog.Filter = "ログファイル(*.log)|*.log|全てのファイル(*.*)|*.*";
			dialog.RestoreDirectory = true;
			if(dialog.ShowDialog() == DialogResult.OK){
				if(!comboBoxTarget.Items.Contains(dialog.FileName)){
					comboBoxTarget.Items.Add(dialog.FileName);
					comboBoxTarget.SelectedIndex = comboBoxTarget.Items.Count-1;
				}
				else{
					int index = 0;
					foreach(string item in comboBoxTarget.Items){
						if(dialog.FileName.Equals(item)){
							comboBoxTarget.SelectedIndex = index;
							break;
						}
						index++;
					}
				}
			}
		}
	}
}
