﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/15
 * Time: 14:06
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Drawing;
using System.Windows.Forms;
using EWatch.Actions;

namespace EWatchUI
{
	/// <summary>
	/// Description of FormActionEdit.
	/// </summary>
	public partial class FormActionEdit : Form
	{
		private BaseAction _action;
		
		public BaseAction Action {
			get {
				return _action;
			}
			set {
				_action = value;
				SetData();
			}
		}
		
		private const string TYPE_NOP = "nop";
		private const string TYPE_EXEC = "execute";
		private const string TYPE_SMTP = "smtp";
		private const string TYPE_SYSLOG = "syslog";
		private const string TYPE_MANTIS = "mantis";

		private ActionExecuteEditControl editExecute;
		private ActionSmtpEditControl editSmtp;
		private ActionSyslogEditControl editSyslog;
		private ActionMantisEditControl editMantis;
		
		public FormActionEdit()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
			comboBoxType.Items.Add(TYPE_NOP);
			comboBoxType.Items.Add(TYPE_EXEC);
			comboBoxType.Items.Add(TYPE_SMTP);
			comboBoxType.Items.Add(TYPE_SYSLOG);
			comboBoxType.Items.Add(TYPE_MANTIS);
			editExecute = new ActionExecuteEditControl();
			editSmtp = new ActionSmtpEditControl();
			editSyslog = new ActionSyslogEditControl();
			editMantis = new ActionMantisEditControl();
			panel1.Controls.Add(editExecute);
			panel1.Controls.Add(editSmtp);
			panel1.Controls.Add(editSyslog);
			panel1.Controls.Add(editMantis);
			SetPanelVisible();
		}
		
		private void SetData()
		{
			if(Action != null){
				SetType();
				SetPanelVisible();
				if(Action is ActionExecute){ editExecute.SetData((ActionExecute)Action); }
				if(Action is ActionSmtp){ editSmtp.SetData((ActionSmtp)Action); }
				if(Action is ActionSyslog){ editSyslog.SetData((ActionSyslog)Action); }
				if(Action is ActionMantis){ editMantis.SetData((ActionMantis)Action); }
			}
		}
		
		private void SetType()
		{
			comboBoxType.Text = Action.GetName();
		}
		
		private void SetPanelVisible()
		{
			editExecute.Visible = TYPE_EXEC.Equals(comboBoxType.Text);
			editSmtp.Visible = TYPE_SMTP.Equals(comboBoxType.Text);
			editSyslog.Visible = TYPE_SYSLOG.Equals(comboBoxType.Text);
			editMantis.Visible = TYPE_MANTIS.Equals(comboBoxType.Text);
		}
		
		void FormActionEditLoad(object sender, EventArgs e)
		{
			SetData();
		}
		
		void ButtonOKClick(object sender, EventArgs e)
		{
			GetData();
			if(Action.Validate()){
				DialogResult = DialogResult.OK;
				Close();
			}
		}
		
		private void GetData()
		{
			string type = comboBoxType.Text;
			if(TYPE_EXEC.Equals(type)){
				Action = editExecute.GetData();
			}
			else if(TYPE_SMTP.Equals(type)){
				Action = editSmtp.GetData();
			}
			else if(TYPE_SYSLOG.Equals(type)){
				Action = editSyslog.GetData();
			}
			else if(TYPE_MANTIS.Equals(type)){
				Action = editMantis.GetData();
			}
			else{
				Action = new ActionNop();
			}
		}
		
		void ComboBoxTypeSelectedIndexChanged(object sender, EventArgs e)
		{
			SetPanelVisible();
		}
	}
}
