﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/07
 * Time: 15:13
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using EWatch.Models;
using EWatch.Models.Configurations;

namespace EWatch.Watchers
{
	/// <summary>
	/// Description of FileWatcher.
	/// </summary>
	public class FileWatcher : BaseWatcher
	{
		private string path;
		private Encoding encoding;
		private long position = -1;
		private bool successRead = true;
		
		public FileWatcher(string path, Encoding encoding, List<ActionTable> actionTable) : base(actionTable)
		{
			this.path = path;
			this.encoding = encoding;
		}
		
		public override void Watch()
		{
			try {
				using(FileStream fs = new FileStream(path, FileMode.Open, FileAccess.Read, FileShare.ReadWrite)){
					fs.Seek(0, SeekOrigin.End);
					if(position < 0){
						position = fs.Position;
					}
					else{
						if(position > fs.Position){
							position = 0;
						}
						fs.Seek(position, SeekOrigin.Begin);
						using(StreamReader sr = new StreamReader(fs, encoding)){
							while(!sr.EndOfStream){
								string line = sr.ReadLine();
								FindAndExecute(new LogData {
								               	TimeStamp = DateTime.Now,
								               	HostName = Environment.MachineName,
								               	Source = path,
								               	Message = line,
								               });
							}
							position = sr.BaseStream.Position;
						}
					}
				}
				successRead = true;
			}
			catch(Exception ex){
				if(successRead){
					log.WarnFormat("Read error : {0}", ex.Message);
					successRead = false;
				}
			}
		}
		
		public override void Dispose()
		{
		}
	}
}
