﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/07
 * Time: 15:11
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Threading;
using EWatch.Actions;
using EWatch.Models;
using EWatch.Models.Configurations;
using EWatch.Utils;
using log4net;

namespace EWatch.Watchers
{
	/// <summary>
	/// Description of BaseWatcher.
	/// </summary>
	public abstract class BaseWatcher : IDisposable
	{
		protected ILog log;
		protected List<ActionTable> actionTable;

		public abstract void Watch();
		
		public BaseWatcher(List<ActionTable> actionTable)
		{
			this.actionTable = actionTable;
			log = LogManager.GetLogger(this.GetType().FullName);
		}
		
		protected void FindAndExecute(LogData data)
		{
			if(!Util.IsNullOrEmpty(actionTable)){
				foreach(ActionTable table in actionTable){
					if(table.IsMatch(data)){
						ExecuteAction(table.Actions, data);
						break;
					}
				}
			}
		}
		
		private void ExecuteAction(IEnumerable<BaseAction> actions, LogData data)
		{
			if(!Util.IsNullOrEmpty(actions)){
				foreach(BaseAction action in actions){
					Thread t = new Thread(new ParameterizedThreadStart(action.ExecuteStart));
					t.Start(data);
				}
			}
		}
		
		public abstract void Dispose();
	}
}
