﻿/*
 * Created by SharpDevelop.
 * User: tjg00813
 * Date: 2012/05/09
 * Time: 13:11
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Reflection;

namespace EWatch.Utils
{
	/// <summary>
	/// Description of Util.
	/// </summary>
	public class Util
	{
        /// <summary>
        /// オブジェクトがnullまたは空かどうかを確認します。
        /// </summary>
        /// <param name="obj">オブジェクト</param>
        /// <returns>null または空であれば true を返します。</returns>
        public static bool IsNullOrEmpty(object obj)
        {
            if (obj == null) return true;
            Type type = obj.GetType();
            if (type == typeof(string))
            {
                return (obj as string).Length == 0;
            }
            else if (type.IsArray)
            {
                return (obj as Array).Length == 0;
            }
            else if (typeof(ICollection).IsAssignableFrom(type))
            {
                return (obj as ICollection).Count == 0;
            }
            else if (typeof(IDictionary).IsAssignableFrom(type))
            {
                return (obj as IDictionary).Count == 0;
            }
            else if (typeof(IEnumerable).IsAssignableFrom(type))
            {
                foreach (var e in (obj as IEnumerable)) return false;
                return true;
            }
            return false;
        }
        
        public static int? StringToInt(string value)
        {
        	if(!IsNullOrEmpty(value)){
	        	int result = 0;
	        	int.TryParse(value, out result);
	        	return result;
        	}
        	return null;
        }
        
        public static DateTime? StringToDateTime(string value)
        {
        	try{
        		return DateTime.Parse(value);
        	}
        	catch(Exception){
        	}
        	return null;
        }
        
        public static Type[] ListTypeInNameSpace(Assembly assembly, string nameSpaceName)
        {
        	List<Type> result = new List<Type>();
        	if(!IsNullOrEmpty(assembly)){
        		foreach(Type t in assembly.GetTypes()){
        			if(t.Namespace.Equals(nameSpaceName) && t.BaseType.Name.Equals("BaseAction")){
        				result.Add(t);
        			}
        		}
        	}
        	return result.ToArray();
        }
        
        public static int GetMonthFromString(string monthString)
        {
        	string[] months = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
        	int result;
        	for(result=0; result<months.Length; result++){
        		if(string.Compare(months[result], monthString, true) == 0){
        			return result+1;
        		}
        	}
        	return 0;
        }
        
        public static string GetMonthString(int month)
        {
        	string[] months = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
        	month--;
        	if(month >= 0 && month < months.Length){
        		return months[month];
        	}
        	return null;
        }
	}
}
