﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/04
 * Time: 11:17
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Configuration.Install;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.ServiceProcess;
using log4net;
using log4net.Config;

namespace EWatch
{
	class Program
	{
		public static void Main(string[] args)
		{
			if(args.Length > 0){
				if("-i".Equals(args[0])){
					InstallService();
					return;
				}
				else if("-u".Equals(args[0])){
					UninstallService();
					return;
				}
				else if("-c".Equals(args[0])){
					string conf = null;
					if(args.Length > 1){
						conf = args[1];
					}
					RunConsole(conf);
					return;
				}
			}
			try {
				ServiceBase.Run(new EWService());
			}
			catch(Exception ex) {
				ILog log = LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);
				log.Error("Service start error", ex);
			}
		}
		
		private static void InstallService()
		{
			if(IsServiceInstalled()){
				return;
			}
			string path = Assembly.GetExecutingAssembly().Location;
			ManagedInstallerClass.InstallHelper(new string[]{ path });
		}
		
		private static void UninstallService()
		{
			if(!IsServiceInstalled()){
				return;
			}
			string path = Assembly.GetExecutingAssembly().Location;
			ManagedInstallerClass.InstallHelper(new string[]{ "/u", path });
		}
		
		private static bool IsServiceInstalled()
		{
			ServiceController[] services = ServiceController.GetServices();
			foreach(ServiceController service in services){
				if(EWInstaller.SERVICE_NAME.Equals(service.ServiceName)){
					return true;
				}
			}
			return false;
		}
		
		private static void RunConsole(string conf)
		{
			try {
				EWService ew = new EWService();
				ew.ConfigFile = conf;
				ew.Initialize();
				ew.StartWatch();
			}
			catch(Exception ex) {
				Console.WriteLine(ex.Message);
				Console.WriteLine(ex.StackTrace);
			}
		}
	}
}