﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/04
 * Time: 12:12
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text.RegularExpressions;
using EWatch.Actions;
using EWatch.Utils;

namespace EWatch.Models.Configurations
{
	/// <summary>
	/// Description of ActionTable.
	/// </summary>
	public class ActionTable
	{
		private List<BaseAction> _actions = new List<BaseAction>();
		
		public string LogLevel { get; set; }
		public string EventSource { get; set; }
		public int? EventId { get; set; }
		public string HostName { get; set; }
		public string MatchPattern { get; set; }
		public string IgnorePattern { get; set; }
		public DateTime? TimeStart { get; set; }
		public DateTime? TimeEnd { get; set; }
		public IEnumerable<BaseAction> Actions {
			get {
				return _actions;
			}
			set {
				_actions = new List<BaseAction>(value);
			}
		}
		
		public ActionTable()
		{
		}
		
		public ActionTable(ActionTable source)
		{
			LogLevel = source.LogLevel;
			EventSource = source.EventSource;
			EventId = source.EventId;
			HostName = source.HostName;
			MatchPattern = source.MatchPattern;
			IgnorePattern = source.IgnorePattern;
			TimeStart = source.TimeStart;
			TimeEnd = source.TimeEnd;
			List<BaseAction> actions = new List<BaseAction>();
			if(!Util.IsNullOrEmpty(source.Actions)){
				foreach(BaseAction action in source.Actions){
					actions.Add(action.Clone());
				}
			}
			Actions = actions;
		}
		
		public void AddAction(BaseAction action)
		{
			_actions.Add(action);
		}
		
		public bool IsMatch(LogData data)
		{
			if(!Util.IsNullOrEmpty(data.Level)){
				if(!Util.IsNullOrEmpty(LogLevel) && !LogLevel.Equals(data.Level)){
					return false;
				}
			}
			if(!Util.IsNullOrEmpty(data.Code)){
				if(!Util.IsNullOrEmpty(EventId) && EventId.Value != data.Code){
					return false;
				}
			}
			if(!Util.IsNullOrEmpty(data.Source)){
				if(!Util.IsNullOrEmpty(EventSource) && !EventSource.Equals(data.Source)){
					return false;
				}
			}
			if(!Util.IsNullOrEmpty(HostName)
				   && !HostName.Equals(data.HostName)
				   && !Regex.IsMatch(data.HostName, HostName)){
				return false;
			}
			if(!Util.IsNullOrEmpty(MatchPattern) && !Regex.IsMatch(data.Message, MatchPattern)){
				return false;
			}
			if(!Util.IsNullOrEmpty(IgnorePattern) && Regex.IsMatch(data.Message, IgnorePattern)){
				return false;
			}
			return true;
		}
	}
}
