﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/04
 * Time: 12:07
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Reflection;
using EWatch.Models;
using EWatch.Utils;
using log4net;
using log4net.Core;
using Newtonsoft.Json;

namespace EWatch.Actions
{
		
	/// <summary>
	/// アクションの基本機能を提供するクラスです。
	/// アクションを実装する際にはこのクラスを継承し、
	/// ・文字列型の Name 固定値を定義
	/// ・Validate メソッドの実装
	/// ・Execute メソッドの実装
	/// をする必要があります。
	/// 定義ファイルの読み込み処理では各アクションクラスの
	/// Name と各プロパティ名を自動的に参照します。
	/// </summary>
	public abstract class BaseAction
	{
		protected ILog log;
		
		public abstract bool Validate();
		
		public abstract void Execute(LogData param);
		
		public BaseAction()
		{
			log = LogManager.GetLogger(this.GetType().FullName);
		}
		
		public override string ToString()
		{
			return JsonConvert.SerializeObject(this);
		}

		public void ExecuteStart(object param)
		{
			try {
				log.Debug("start");
				Execute((LogData)param);
				ActionLogger.Info(GetName(), (LogData)param);
			}
			catch(Exception ex) {
				ActionLogger.Error(GetName(), ex.Message, (LogData)param);
			}
			finally {
				log.Debug("end");
			}
		}

		public Dictionary<string,object> GetProperties()
		{
			Dictionary<string,object> result = new Dictionary<string, object>();
			PropertyInfo[] properties = this.GetType().GetProperties();
			foreach(PropertyInfo pi in properties){
				result.Add(pi.Name, pi.GetValue(this, null));
			}
			return result;
		}
		
		public string GetName()
		{
			try {
				FieldInfo fi = this.GetType().GetField("Name");
				object value = fi.GetValue(this);
				if(value is string){
					return (string)value;
				}
			}
			catch(Exception) {
			}
			return null;
		}
		
		public BaseAction Clone()
		{
			BaseAction instance = (BaseAction)Activator.CreateInstance(this.GetType());
			PropertyInfo[] properties = this.GetType().GetProperties();
			foreach(PropertyInfo pi in properties){
				pi.SetValue(instance, pi.GetValue(this, null), null);
			}
			return instance;
		}
	}
	
}
