﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/04
 * Time: 17:25
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Net.Mail;
using System.Text;
using EWatch.Models;
using EWatch.Utils;

namespace EWatch.Actions
{
	/// <summary>
	/// SMTPサーバーにメール配信を要求するアクションです。
	/// </summary>
	public class ActionSmtp : BaseAction
	{
		public const string Name = "smtp";
		
		private string _serverHost;
		private int _serverPort;

		public string ServerHost {
			get {
				return string.Format("{0}:{1}", _serverHost, _serverPort);
			}
			set {
				string[] hostAndPort = value.Split(new char[]{ ':' });
				_serverHost = hostAndPort[0];
				_serverPort = 25;
				if(hostAndPort.Length >= 2){
					int.TryParse(hostAndPort[1], out _serverPort);
				}
			}
		}
		public string ToAddress { get; set; }
		public string FromAddress { get; set; }
		
		public ActionSmtp()
		{
		}
		
		public override bool Validate()
		{
			if(Util.IsNullOrEmpty(_serverHost)){
				log.Error("ServerHost is not specified.");
				return false;
			}
			if(Util.IsNullOrEmpty(FromAddress)){
				log.Error("FromAddress is not specified.");
				return false;
			}
			if(Util.IsNullOrEmpty(ToAddress)){
				log.Error("ToAddress is not specified.");
				return false;
			}
			return true;
		}
		
		public override void Execute(LogData data)
		{
			StringBuilder body = new StringBuilder();
			body.AppendFormat("Time:\t{0}\r\n", data.TimeStamp.Value.ToString("yyyy-MM-dd HH:mm:ss.fff"));
			if(!Util.IsNullOrEmpty(data.Level)){
				body.AppendFormat("level:\t{0}\r\n", data.Level);
				body.AppendFormat("code:\t{0}\r\n", data.Code);
			}
			if(!Util.IsNullOrEmpty(data.HostName)){
				body.AppendFormat("host:\t{0}\r\n", data.HostName);
			}
			if(!Util.IsNullOrEmpty(data.Source)){
				body.AppendFormat("source:\t{0}\r\n", data.Source);
			}
			body.AppendFormat("{0}\r\n", data.Message);
			Send(data.Message, body.ToString());
		}
		
		private void Send(string subject, string body)
		{
			SmtpClient client = new SmtpClient();
			client.Host = _serverHost;
			client.Port = _serverPort;
			client.Send(FromAddress, ToAddress, subject, body);
		}
	}
}
