﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/16
 * Time: 8:54
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.IO;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using EWatch.Models;
using EWatch.Utils;

namespace EWatch.Actions
{
	/// <summary>
	/// MantisBTに障害情報として登録するアクションです。
	/// </summary>
	public class ActionMantis : BaseAction
	{
		public const string Name = "mantis";

		public string BaseUrl { get; set; }
		public string UserID { get; set; }
		public string Password { get; set; }
		public string Project { get; set; }
		
		private CookieContainer _cookie;
		
		public ActionMantis()
		{
		}
		
		public override void Execute(EWatch.Models.LogData param)
		{
			_cookie = new CookieContainer();
			DoLogin();
			string projectId = GetProjectID();
			SetProjectID(projectId);
			Report(projectId, param.Message, GetDescription(param));
		}
		
		public override bool Validate()
		{
			if(Util.IsNullOrEmpty(BaseUrl)){
				log.Error("BaseUrl is not specified.");
				return false;
			}
			if(Util.IsNullOrEmpty(Project)){
				log.Error("Project is not specified.");
				return false;
			}
			return true;
		}
		
		private void DoLogin()
		{
			Request("login.php", null);
			Request("login.php", string.Format("username={0}&password={0}&secure_session=on",
			                                    UserID, Password));
		}

		private string GetProjectID()
		{
			/*
			 * ....<select name="project_id" class="small" ...><option value="0" selected="selected" >全プロジェクト</option>
			 * <option value="2">やってみる</option>
			 * <option value="1">テストプロジェクト1</option>
			 * </select>
			 */
			log.DebugFormat("GetProjectID {0}", Project);
			string response = Request("my_view_page.php", null);
			response = Regex.Replace(response, "[\r\n]", "");
			Match match = Regex.Match(response, "<select name=\"project_id\"[^>]+>(<option[^>]+>[^<]+</option>){1,100}");
			if(match != null){
				MatchCollection mm = Regex.Matches(match.Groups[0].Value, "<option value=\"([^\"]+)\"[^>]*>([^<]+)</option>");
				foreach(Match m in mm){
					log.DebugFormat("project name={0} id={1}", m.Groups[2].Value, m.Groups[1].Value);
					string name = m.Groups[2].Value;
					if(name.Equals(Project) || Regex.IsMatch(name, Project)){
						return m.Groups[1].Value;
					}
				}
			}
			log.Debug("Cannot get project ID");
			throw new Exception(string.Format("Cannot get project ID of {0}.", Project));
		}
		
		private void SetProjectID(string projectId)
		{
			log.DebugFormat("SetProjectID {0}", projectId);
			Request("set_project.php", string.Format("project_id={0}", projectId));
		}
		
		private void Report(string projectId, string summary, string description)
		{
			string response = Request("bug_report_page.php", null);
			Match m = Regex.Match(response, "name=\"bug_report_token\" value=\"([^\"]*)\"");
			if(m != null){
				string token = m.Groups[1].Value;
				Request("bug_report.php",
				        string.Format("bug_report_token={0}&project_id={1}&category_id={2}&summary={3}&description={4}",
				                      token, projectId, 1,
				                      HttpUtility.UrlEncode(summary),
				                      HttpUtility.UrlEncode(description)));
				return;
			}
			throw new Exception(string.Format("Cannot report. projectID={0}.", projectId));
		}
		
		private string Request(string path, string postData)
		{
			byte[] data = null;
			if(!Util.IsNullOrEmpty(postData)){
				data = Encoding.ASCII.GetBytes(postData);
			}
			HttpWebRequest req = (HttpWebRequest)WebRequest.Create(string.Concat(BaseUrl, path));
			req.Method = "POST";
			req.CookieContainer = _cookie;
			if(data != null){
				req.ContentType = "application/x-www-form-urlencoded";
				req.ContentLength = data.Length;
				
				using(Stream s = req.GetRequestStream()){
					s.Write(data, 0, data.Length);
				}
			}
			
			string result = null;
			WebResponse res = req.GetResponse();
			using(StreamReader sr = new StreamReader(res.GetResponseStream())){
				result = sr.ReadToEnd();
			}
			return result;
		}
		
		private string GetDescription(LogData data)
		{
			StringBuilder result = new StringBuilder();
			result.AppendFormat("Time:\t{0}\r\n", data.TimeStamp.Value.ToString("yyyy-MM-dd HH:mm:ss.fff"));
			if(!Util.IsNullOrEmpty(data.Level)){
				result.AppendFormat("level:\t{0}\r\n", data.Level);
				result.AppendFormat("code:\t{0}\r\n", data.Code);
			}
			if(!Util.IsNullOrEmpty(data.HostName)){
				result.AppendFormat("host:\t{0}\r\n", data.HostName);
			}
			if(!Util.IsNullOrEmpty(data.Source)){
				result.AppendFormat("source:\t{0}\r\n", data.Source);
			}
			result.AppendFormat("{0}\r\n", data.Message);
			return result.ToString();
		}
	}
}
