﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/18
 * Time: 15:09
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Net;
using System.Net.Sockets;
using System.Text;
using EWatch.Utils;

namespace EWatch.Actions
{
	/// <summary>
	/// Description of ActionForward.
	/// </summary>
	public class ActionForward : BaseAction
	{
		public const string Name = "forward";
		
		private string _destinationHost;
		private int _destinationPort;

		public string Destination {
			get {
				return string.Format("{0}:{1}", _destinationHost, _destinationPort);
			}
			set {
				string[] hostAndPort = value.Split(new char[]{ ':' });
				_destinationHost = hostAndPort[0];
				_destinationPort = 31300;
				if(hostAndPort.Length >= 2){
					int.TryParse(hostAndPort[1], out _destinationPort);
				}
			}
		}
		
		public ActionForward()
		{
		}
		
		public override bool Validate()
		{
			if(Util.IsNullOrEmpty(Destination)) return false;
			return true;
		}
		
		public override void Execute(EWatch.Models.LogData param)
		{
			byte[] sendData = Encoding.UTF8.GetBytes(param.ToString());
			UdpClient client = new UdpClient();
			IPAddress[] addr = Dns.GetHostAddresses(_destinationHost);
			if(addr.Length > 0){
				foreach(IPAddress a in addr){
					if(a.AddressFamily == AddressFamily.InterNetwork){
						client.Send(sendData, sendData.Length, new IPEndPoint(a, _destinationPort));
						return;
					}
				}
			}
			throw new Exception("Invalid destination address");
		}
	}
}
