﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/04
 * Time: 17:25
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Diagnostics;
using EWatch.Models;
using EWatch.Utils;

namespace EWatch.Actions
{
	/// <summary>
	/// コマンド実行のアクションです。
	/// </summary>
	public class ActionExecute : BaseAction
	{
		public const string Name = "execute";

		public string CommandLine { get; set; }
		
		public ActionExecute()
		{
		}
		
		public override bool Validate()
		{
			if(Util.IsNullOrEmpty(CommandLine)) return false;
			log.DebugFormat("validate : {0}", CommandLine);
			return true;
		}
		
		public override void Execute(LogData data)
		{
			string timestampString = (data.TimeStamp ?? DateTime.Now).ToString("yyyy-MM-dd HH:mm:ss.fff");
			string cmdLine = CommandLine
				.Replace("$timestamp", timestampString)
				.Replace("$hostname", data.HostName)
				.Replace("$source", data.Source)
				.Replace("$level", data.Level)
				.Replace("$code", data.Code.ToString())
				.Replace("$message", data.Message);
			ProcessStartInfo psi = new ProcessStartInfo();
			psi.UseShellExecute = false;
			psi.FileName = "cmd";
			psi.Arguments = string.Format("/c \"{0}\"", cmdLine);
			log.DebugFormat("Run : {0}", cmdLine);
			Process p = Process.Start(psi);
			p.WaitForExit();
			if(p.ExitCode != 0){
				throw new Exception(string.Format("exitcode={0}", p.ExitCode));
			}
		}
	}
}
