package com.yuji.em;

import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

import com.yuji.em.common.Constant;
import com.yuji.em.utility.BaseActivity;
import com.yuji.em.utility.EditPrefUtil;

public class HeaderActivity extends BaseActivity {
	private EditPrefUtil pref = new EditPrefUtil(this);
	private EditText editText = null;
	private Button okButton = null;
	private Button cancelButton = null;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.header);

		editText = (EditText) this.findViewById(R.id.headerEditText);
		okButton = (Button) this.findViewById(R.id.headerOkButton);
		cancelButton = (Button) this.findViewById(R.id.headerCancelButton);

		okButton.setOnClickListener(new OnClickListener(){
			public void onClick(View v) {
				okButtonOnClick();
			}});
		cancelButton.setOnClickListener(new OnClickListener(){
			public void onClick(View v) {
				cancelButtonOnClick();
			}});
		
		String header = pref.get(Constant.PREF_HEADER, Constant.DEFAULT_HEADER_TEXT);
		editText.setText(header);
	}

	private void okButtonOnClick(){
		String header = editText.getText().toString();
		pref.put(Constant.PREF_HEADER, header);
		pref.update();
		
		finish();
	}

	private void cancelButtonOnClick(){
		finish();		
	}
}
