/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.conn.mobile;

import com.evernote.client.conn.mobile.FileDataException;
import com.evernote.edam.type.Data;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TStruct;

public class FileData
extends Data {
    private static final TStruct STRUCT_DESC = new TStruct("Data");
    private static final TField BODY_HASH_FIELD_DESC = new TField("bodyHash", 11, 1);
    private static final TField SIZE_FIELD_DESC = new TField("size", 8, 2);
    private static final TField BODY_FIELD_DESC = new TField("body", 11, 3);
    private static final long serialVersionUID = 1L;
    private static boolean mbStop = false;
    private File mBodyFile;

    public static synchronized void cancel() {
        mbStop = true;
    }

    public FileData(byte[] bodyHash, File file) {
        mbStop = false;
        this.mBodyFile = file;
        this.setBodyHash(bodyHash);
        this.setSize((int)file.length());
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.getBodyHash() != null && this.isSetBodyHash()) {
            oprot.writeFieldBegin(BODY_HASH_FIELD_DESC);
            oprot.writeBinary(ByteBuffer.wrap(this.getBodyHash()));
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SIZE_FIELD_DESC);
        oprot.writeI32(this.getSize());
        oprot.writeFieldEnd();
        if (this.mBodyFile != null && this.mBodyFile.isFile()) {
            oprot.writeFieldBegin(BODY_FIELD_DESC);
            FileInputStream s = null;
            try {
                try {
                    s = new FileInputStream(this.mBodyFile);
                    oprot.writeStream((InputStream)s, this.mBodyFile.length());
                }
                catch (FileNotFoundException e) {
                    throw new TException("Failed to write binary body:" + this.mBodyFile, (Throwable)e);
                }
            }
            finally {
                try {
                    if (s != null) {
                        ((InputStream)s).close();
                    }
                }
                catch (Exception exception) {}
            }
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public void writexx(TProtocol oprot) throws TException {
        if (this.getBodyHash() == null) {
            throw new TProtocolException("Invalid null field: bodyHash");
        }
        TStruct struct = new TStruct("Data");
        oprot.writeStructBegin(struct);
        TField field = new TField("bodyHash", 11, 1);
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.getBodyHash());
        oprot.writeFieldEnd();
        field = new TField("size", 8, 2);
        oprot.writeFieldBegin(field);
        int size = this.getSize();
        oprot.writeI32(size);
        oprot.writeFieldEnd();
        field = new TField("body", 11, 3);
        oprot.writeFieldBegin(field);
        oprot.writeI32(size);
        try {
            int len;
            byte[] buffer = new byte[4096];
            FileInputStream in = new FileInputStream(this.mBodyFile);
            while ((len = in.read(buffer)) >= 0) {
                if (mbStop) {
                    throw new FileDataException("Output canceled");
                }
                if (len == buffer.length) {
                    oprot.writeBinary(buffer);
                    continue;
                }
                ByteArrayOutputStream dest = new ByteArrayOutputStream();
                dest.write(buffer, 0, len);
                oprot.writeBinary(dest.toByteArray());
            }
            in.close();
        }
        catch (Exception e) {
            throw new FileDataException(e);
        }
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }
}

