package com.yuji.ef.utility;

import java.util.HashMap;
import java.util.Map;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

public class BitmapCacheFactory {
	public static BitmapCacheFactory getInstance() {
		if (instance == null) {
			instance = new BitmapCacheFactory();
		}
		return instance;
	}

	private static BitmapCacheFactory instance = null;
	private Resources resources = null;
	private Map<Integer, Bitmap> map = new HashMap<Integer, Bitmap>();
	
	private BitmapCacheFactory() {

	}

	public void init(Context context){
		resources = context.getResources();
		map.clear();
	}
	
	public Bitmap get(int id){
		Bitmap bmp = map.get(id);
		if (bmp != null){
			return bmp;
		}
		bmp = BitmapFactory.decodeResource(resources, id);
		map.put(id, bmp);
		return bmp;
	}
}
