package com.yuji.ef.dao;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import android.database.sqlite.SQLiteDatabase;

import com.yuji.ef.dao.Node.Status;

public class NodeCacheDao extends NodeDaoImpl implements IDao<Node>, NodeDao {
	private static final int MAP_SIZE = 8;

	private static IDao<Node> instance = null;
	//private static NodeDao dao = (NodeDao) NodeDaoImpl.getInstance();
	private static LinkedHashMap<Long, Node> map = new LinkedHashMap<Long, Node>(
			MAP_SIZE, (float) 0.75, true) {
		@Override
		protected boolean removeEldestEntry(Map.Entry eldest) {
			return size() > MAP_SIZE;
		}
	};

	public static IDao<Node> getInstance() {
		if (instance == null) {
			instance = new NodeCacheDao();
		}
		return instance;
	}

	private NodeCacheDao() {

	}

//	@Override
//	public void onCreate(SQLiteDatabase db) {
//		dao.onCreate(db);
//	}
//
//	@Override
//	public void init(SQLiteDatabase db) {
//		dao.init(db);
//	}
//
//	@Override
//	public void start(SQLiteDatabase db) {
//		dao.start(db);
//	}
//
//	@Override
//	public void start2(SQLiteDatabase db) {
//		dao.start2(db);
//	}
//
//	@Override
//	public List<Node> search() {
//		return dao.search();
//	}
//
//	@Override
//	public Node searchRoot() {
//		return dao.searchRoot();
//	}
//
//	@Override
//	public Node searchRoot(SQLiteDatabase db) {
//		return dao.searchRoot(db);
//	}
//
//	@Override
//	public Node searchById(long id) {
//		return dao.searchById(id);
//	}

	@Override
	public Node searchById(SQLiteDatabase db, long id) {
		Node n = map.get(id);
		if (n != null) {
			return n;
		}
		n = super.searchById(db, id);
		map.put(id, n);
		return n;
	}

//	@Override
//	public Node searchByGuid(SQLiteDatabase db, String guid) {
//		return dao.searchByGuid(db, guid);
//	}
//
//	@Override
//	public boolean isEmpty() {
//		return dao.isEmpty();
//	}
//
//	@Override
//	public long add(Node node) {
//		return dao.add(node);
//	}
//
//	@Override
//	public long addNT(Node node) {
//		return dao.addNT(node);
//	}
//
//	@Override
//	public long addChildrenId(Node node, long id) {
//		return dao.addChildrenId(node, id);
//	}
//
//	@Override
//	public long addChildrenIdNT(Node node, long id) {
//		return dao.addChildrenIdNT(node, id);
//	}

	@Override
	public long updateChildrenNT(Node node, String children) {
		map.remove(node.getId());
		return super.updateChildrenNT(node, children);
	}

//	@Override
//	public long removeChildrenId(Node node, long id) {
//		return dao.removeChildrenId(node, id);
//	}

	@Override
	public long removeChildrenIdNT(Node node, long id) {
		map.remove(node.getId());
		return super.removeChildrenIdNT(node, id);
	}

//	@Override
//	public long updateStatus(Node node, Status status) {
//		return dao.updateStatus(node, status);
//	}
//
//	@Override
//	public long updateStatus(SQLiteDatabase db, Node node, Status status) {
//		return dao.updateStatus(db, node, status);
//	}

	@Override
	public long updateStatusNT(Node node, Status status) {
		map.remove(node.getId());
		return super.updateStatusNT(node, status);
	}

//	@Override
//	public long updateName(Node node, String name) {
//		return dao.updateName(node, name);
//	}
//
//	@Override
//	public long updateName(SQLiteDatabase db, Node node, String name) {
//		return dao.updateName(db, node, name);
//	}

	@Override
	public long updateNameNT(Node node, String name) {
		map.remove(node.getId());
		return super.updateNameNT(node, name);
	}

//	@Override
//	public long updateParent(Node node, long parent) {
//		return dao.updateParent(node, parent);
//	}
//
//	@Override
//	public long updateParent(SQLiteDatabase db, Node node, long parent) {
//		return dao.updateParent(db, node, parent);
//	}

	@Override
	public long updateSelectedNT(Node node, boolean isSelected) {
		map.remove(node.getId());
		return super.updateSelectedNT(node, isSelected);
	}
	
	@Override
	public long updateGuidNT(Node node, String guid) {
		map.remove(node.getId());
		return super.updateGuidNT(node, guid);
	}

	@Override
	public long updateParentNT(Node node, long parent) {
		map.remove(node.getId());
		return super.updateParentNT(node, parent);
	}

//	@Override
//	public long updateChildren(Node node, String children) {
//		return dao.updateChildren(node, children);
//	}
//
//	@Override
//	public long delete(long id) {
//		return dao.delete(id);
//	}
//
//	@Override
//	public long delete(SQLiteDatabase db, long did) {
//		return dao.delete(db, did);
//	}

	@Override
	public long deleteNT(long did) {
		map.remove(did);
		return super.deleteNT(did);
	}

//	@Override
//	public long delete() {
//		return dao.delete();
//	}
//
//	@Override
//	public long delete(SQLiteDatabase db) {
//		return dao.delete(db);
//	}

	@Override
	public void deleteNT() {
		map.clear();
		super.deleteNT();
	}
}
