package com.yuji.ef.dao;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.yuji.ef.common.CommonUtil;
import com.yuji.ef.utility.Debug;
import com.yuji.ef.utility.FolderUtil;

public class BookDao implements IDao<Book> {
	private static IDao<Book> instance = null;
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement updateStmt = null;
	private SQLiteStatement deleteIdStmt = null;

	public static IDao<Book> getInstance() {
		if (instance == null) {
			instance = new BookDao();
		}
		return instance;
	}

	private BookDao() {

	}

	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE BOOK (" + android.provider.BaseColumns._ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT," + "TYPE INTEGER,"
				+ "GUID TEXT," + "NID INTEGER," + "NAME TEXT" + ");");

		// TODO
		// CREATE INDEX インデックス名 ON テーブル名(カラム名1, カラム名2, ...);
	}

	public void init(SQLiteDatabase db) {
		insertStmt = db.compileStatement("INSERT INTO BOOK (" + "GUID,"
				+ "NID," + "NAME" + ") VALUES (" + "?,?,?" + ");");
		updateStmt = db.compileStatement("UPDATE BOOK SET NAME = ? WHERE "
				+ android.provider.BaseColumns._ID + " = ?");
		deleteIdStmt = db.compileStatement("DELETE FROM BOOK WHERE "
				+ android.provider.BaseColumns._ID + " = ?");
	}

	public void start(SQLiteDatabase db) {

	}

	public List<Book> search() {
		return search(null, null, null);
	}

	public List<Book> search(SQLiteDatabase db) {
		return search(db, null, null, null);
	}

	public Book searchById(long id) {
		String selection = android.provider.BaseColumns._ID + " = ?";
		String[] selectionArgs = { String.valueOf(id) };
		String orderBy = null;
		List<Book> list = search(selection, selectionArgs, orderBy);
		if (list.size() <= 0) {
			return null;
		}
		return list.get(0);
	}

	public Book searchByGuid(SQLiteDatabase db, String guid) {
		String selection = "GUID" + " = ?";
		String[] selectionArgs = { guid };
		String orderBy = null;
		List<Book> list = search(db, selection, selectionArgs, orderBy);
		if (list.size() <= 0) {
			return null;
		}
		return list.get(0);
	}

	private List<Book> search(String selection, String[] selectionArgs,
			String orderBy) {
		return search(DatabaseHelper.getInstance().getSQLiteDatabase(),
				selection, selectionArgs, orderBy);
	}

	private List<Book> search(SQLiteDatabase db, String selection,
			String[] selectionArgs, String orderBy) {
		List<Book> list = new ArrayList<Book>();
		Cursor cursor = null;
		try {
			cursor = db.query("BOOK", new String[] {
					android.provider.BaseColumns._ID, "GUID", "NID", "NAME" },
					selection, selectionArgs, null, null, orderBy);
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				Book book = new Book(cursor.getLong(0), cursor.getString(1),
						cursor.getLong(2), cursor.getString(3));
				list.add(book);
				cursor.moveToNext();
			}
		} catch (SQLException e) {
			Debug.d(this, null, e);
			list = null;
		} catch (Exception e) {
			Debug.d(this, null, e);
			list = null;
		} finally {
			if (cursor != null) {
				cursor.close();
				cursor = null;
			}
		}
		return list;
	}

	public boolean isEmpty() {
		List<Book> list = search();
		return list == null || list.size() <= 0;
	}

	public long add(Book book) {
		return add(DatabaseHelper.getInstance().getSQLiteDatabase(), book);
	}

	private long add(SQLiteDatabase db, Book book) {
		long id = -1;
		db.beginTransaction();
		try {
			id = addNT(book);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long addNT(Book book) {
		long id = -1;
		int i = 1;
		SQLiteStatement stmt = insertStmt;
		stmt.bindString(i++, book.getGuid());
		stmt.bindLong(i++, book.getNId());
		stmt.bindString(i++, book.getName());
		id = stmt.executeInsert();
		return id;
	}

	public long delete(long id) {
		return delete(DatabaseHelper.getInstance().getSQLiteDatabase(), id);
	}

	public long updateName(Book book, String name) {
		return updateName(DatabaseHelper.getInstance().getSQLiteDatabase(),
				book, name);
	}

	public long updateName(SQLiteDatabase db, Book book, String name) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateNameNT(book, name);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long updateNameNT(Book book, String name) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = updateStmt;
		stmt.bindString(i++, name);
		stmt.bindLong(i++, book.getId());
		id = stmt.executeInsert();
		return id;
	}

	public long delete(SQLiteDatabase db, long did) {
		long id = -1;

		db.beginTransaction();
		try {
			id = deleteNT(did);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long deleteNT(long did) {
		long id = -1; // TODO
		int i = 1;

		SQLiteStatement stmt = deleteIdStmt;
		stmt.bindLong(i++, did);
		stmt.execute();
		return id;
	}
}