package com.yuji.ef;

import java.util.List;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.yuji.ef.common.CommonUtil;
import com.yuji.ef.common.Constant;
import com.yuji.ef.dao.LockDao;
import com.yuji.ef.dao.Node;
import com.yuji.ef.dao.NodeCacheDao;
import com.yuji.ef.dao.NodeDao;
import com.yuji.ef.pref.EditPrefUtil;
import com.yuji.ef.service.NoteUpdatorService;
import com.yuji.ef.task.NoteUpdateTask;
import com.yuji.ef.utility.AsyncTaskCommand;
import com.yuji.ef.utility.BaseActivity;
import com.yuji.ef.utility.Debug;
import com.yuji.ef.utility.EvernoteUtil;

public class SettingActivity extends BaseActivity {
	private EditPrefUtil pref = new EditPrefUtil(this);

	private LinearLayout msgLayout;
	private TextView confirmMsg;
	private Button loginButton;
	private Button listButton;
	private Button bookButton;
	private Button updateButton;
	private Spinner updateSpinner;
	private Button closeButton;

	private boolean isRegister = false;
	private boolean isBind = false;

	private boolean lock = false;
	private boolean isInit = true;

	private class NoteUpdatorReceiver extends BroadcastReceiver {

		@Override
		public void onReceive(Context context, Intent intent) {
			Toast toast = Toast.makeText(getApplicationContext(), "Time over!",
					Toast.LENGTH_LONG);
			toast.show();
		}
	}

	private NoteUpdatorService noteUpdatorService;
	private final NoteUpdatorReceiver receiver = new NoteUpdatorReceiver();

	private ServiceConnection serviceConnection = new ServiceConnection() {
		public void onServiceConnected(ComponentName className, IBinder service) {
			noteUpdatorService = ((NoteUpdatorService.KitchenTimerBinder) service)
					.getService();
		}

		public void onServiceDisconnected(ComponentName className) {
			noteUpdatorService = null;
		}
	};

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.setting);

		msgLayout = (LinearLayout) findViewById(R.id.settingMsgLayout);
		confirmMsg = (TextView) findViewById(R.id.settingConfirmMsg);
		loginButton = (Button) findViewById(R.id.settingLoginButton);
		listButton = (Button) findViewById(R.id.settingListButton);
		bookButton = (Button) findViewById(R.id.settingBookButton);
		updateButton = (Button) findViewById(R.id.settingUpdateButton);
		updateSpinner = (Spinner) findViewById(R.id.settingUpdateSpinner);
		closeButton = (Button) findViewById(R.id.settingCloseButton);

		loginButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				loginButtonOnClick();
			}
		});
		listButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				listButtonOnClick();
			}
		});
		bookButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				bookButtonOnClick();
			}
		});
		updateButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				updateButtonOnClick();
			}
		});
		closeButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				closeButtonOnClick();
			}
		});
		updateSpinner.setOnItemSelectedListener(new OnItemSelectedListener() {
			public void onItemSelected(AdapterView<?> parent, View view,
					int position, long id) {
				updateSpinnerItemSelected(parent, view, position, id);
			}

			public void onNothingSelected(AdapterView<?> view) {
				;
			}
		});

		ArrayAdapter<CharSequence> noteOrderAdapter = ArrayAdapter
				.createFromResource(this, R.array.note_update_time_array,
						android.R.layout.simple_spinner_item);
		noteOrderAdapter
				.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		updateSpinner.setAdapter(noteOrderAdapter);
	}

	@Override
	protected void onStart() {
		super.onStart();
	}

	@Override
	protected void onResume() {
		super.onResume();

		int updateTime = pref.getInt(Constant.PREF_UPDATE_TIME, 0);

		String[] values = getResources().getStringArray(
				R.array.note_update_time_array_value);
		for (int i = 0; i < values.length; i++) {
			if (updateTime <= Integer.parseInt(values[i])) {
				updateSpinner.setSelection(i);
				break;
			}
		}

		if (isInit) {
			setStatus();
			isInit = false;
		}
	}

	@Override
	protected void onPause() {
		int prevUpdateTime = pref.getInt(Constant.PREF_UPDATE_TIME, 0);
		String[] values = getResources().getStringArray(
				R.array.note_update_time_array_value);
		int pos = updateSpinner.getSelectedItemPosition();
		int updateTime = Integer.parseInt(values[pos]);

		if (prevUpdateTime != updateTime) {
			stopService();

			pref.put(Constant.PREF_UPDATE_TIME, updateTime);
			pref.update();
		}

		if (isBind) {
			unbindService(serviceConnection); // バインド解除
			isBind = false;
		}
		if (isRegister) {
			unregisterReceiver(receiver); // 登録解除
			isRegister = false;
		}

		if (prevUpdateTime != updateTime) {
			if (updateTime > 0) {
				updateNote();
			}
		}

		super.onPause();
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		isInit = true;
	}

	private void stopService() {
		NoteUpdatorService.stopService(this);
	}

	private void updateNote() {
		try {
			stopService();

			Intent intent = new Intent(this, NoteUpdatorService.class);
			intent.setAction(NoteUpdatorService.ACTION_START);
			startService(intent);
			IntentFilter filter = new IntentFilter(NoteUpdatorService.ACTION);
			registerReceiver(receiver, filter);
			isRegister = true;

			// サービスにバインド
			bindService(intent, serviceConnection, Context.BIND_AUTO_CREATE);
			isBind = true;
		} catch (Exception e) {
			Debug.d(this, null, e);
		}
	}

	private void loginButtonOnClick() {
		Intent intent = new Intent(this, (Class<?>) OAuthActivity.class);
		startActivityForResult(intent, 0);
	}

	private void listButtonOnClick() {
		updateButton(false);
	}

	private void bookButtonOnClick() {
		Intent intent = new Intent(this, (Class<?>) BookListActivity.class);
		startActivityForResult(intent, 0);
	}

	private void updateButtonOnClick() {
		updateButton(true);
	}

	private void updateButton(boolean isAll) {
		LockDao lockDao = (LockDao) LockDao.getInstance();
		lock = lockDao.lock(this, Constant.LOCK_UPDATE_NOTE);

		if (!lock) {
			setStatus();
			return;
		}

		NoteUpdateTask task = new NoteUpdateTask(this, true, true, isAll);

		AsyncTaskCommand command = new AsyncTaskCommand(this, task);
		// TODO
		// command.setTitle(getString(R.string.updatorNoteDialogTitle));
		// command.setButtonTitle(getString(R.string.cancelButton));
		command.setCancelable(false);
		command.setDialog(false);
		command.execute("");

		setStatus();
	}

	public void done(int errorCode) {
		LockDao lockDao = (LockDao) LockDao.getInstance();
		lockDao.unlock(this, Constant.LOCK_UPDATE_NOTE);
		lock = false;

		setStatus();
	}

	private void updateSpinnerItemSelected(AdapterView<?> parent, View view,
			int position, long id) {

	}

	private void closeButtonOnClick() {
		finish();
	}

	private void setStatus() {
		if (lock) {
			msgLayout.setVisibility(View.VISIBLE);
			confirmMsg.setText(getString(R.string.settingUpdateMsg));

			loginButton.setEnabled(false);
			listButton.setEnabled(false);
			bookButton.setEnabled(false);
			updateButton.setEnabled(false);
			updateSpinner.setEnabled(false);

			return;
		}

		EvernoteUtil util = EvernoteUtil.getInstance();
		if (!util.isLoggedIn()) {
			msgLayout.setVisibility(View.VISIBLE);
			confirmMsg.setText(getString(R.string.settingLoginMsg));

			loginButton.setEnabled(true);
			listButton.setEnabled(false);
			listButton.setVisibility(View.GONE);
			bookButton.setEnabled(false);
			updateButton.setEnabled(false);
			updateSpinner.setEnabled(false);

			return;
		}

		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();
		List<Node> list = dao.searchBook();
		if (list == null || list.size() <= 0){
			msgLayout.setVisibility(View.VISIBLE);
			confirmMsg.setText(getString(R.string.settingDoListMsg));

			loginButton.setEnabled(true);
			listButton.setEnabled(true);
			listButton.setVisibility(View.VISIBLE);
			bookButton.setEnabled(false);
			updateButton.setEnabled(false);
			updateSpinner.setEnabled(false);

			return;
		}		
		
		list = dao.searchSelectedBook();
		if (list == null || list.size() <= 0) {
			msgLayout.setVisibility(View.VISIBLE);
			confirmMsg.setText(getString(R.string.settingDoSelectMsg));

			loginButton.setEnabled(true);
			listButton.setEnabled(false);
			listButton.setVisibility(View.GONE);
			bookButton.setEnabled(true);
			updateButton.setEnabled(false);
			updateSpinner.setEnabled(false);

			return;
		}

		if (false) {
			// TODO
			msgLayout.setVisibility(View.VISIBLE);
			confirmMsg.setText(getString(R.string.settingDoUpdateMsg));

			loginButton.setEnabled(true);
			listButton.setEnabled(false);
			listButton.setVisibility(View.GONE);
			bookButton.setEnabled(true);
			updateButton.setEnabled(true);
			updateSpinner.setEnabled(true);
			return;
		}

		loginButton.setEnabled(true);
		listButton.setEnabled(false);
		listButton.setVisibility(View.GONE);
		bookButton.setEnabled(true);
		updateButton.setEnabled(true);
		updateSpinner.setEnabled(true);
		msgLayout.setVisibility(View.GONE);
	}
}
