package com.yuji.ef;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ScrollView;

public class IconScrollView extends ScrollView {
	private boolean isScrollable = true;

	public void setScrollable(boolean isScrollable) {
		this.isScrollable = isScrollable;
	}

	public IconScrollView(Context context) {		
		super(context);
	}

	public IconScrollView(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public IconScrollView(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
	}

	@Override
    public boolean onTouchEvent(MotionEvent event) {
		if (event.getAction() == MotionEvent.ACTION_CANCEL) {
			;
		}
		if (event.getAction() == MotionEvent.ACTION_UP) {
			this.setScrollable(true);
		}
		if (!isScrollable){
			return true;
		}
		return super.onTouchEvent(event);
	}
}
