/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.oauth.android;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.evernote.client.oauth.EvernoteAuthToken;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.EvernoteApi;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class EvernoteOAuthActivity
extends Activity {
    private static final String TAG = "EvernoteOAuthActivity";
    static final String EXTRA_EVERNOTE_HOST = "EVERNOTE_HOST";
    static final String EXTRA_CONSUMER_KEY = "CONSUMER_KEY";
    static final String EXTRA_CONSUMER_SECRET = "CONSUMER_SECRET";
    static final String EXTRA_AUTH_TOKEN = "AUTH_TOKEN";
    static final String EXTRA_NOTESTORE_URL = "NOTESTORE_URL";
    static final String EXTRA_WEBAPI_URL_PREFIX = "WEBAPI_URL_PREFIX";
    static final String EXTRA_USERID = "USER_ID";
    private String evernoteHost = null;
    private String consumerKey = null;
    private String consumerSecret = null;
    private String requestToken = null;
    private String requestTokenSecret = null;
    static EvernoteAuthToken authToken = null;
    static boolean startedAuthentication;
    private boolean receivedCallback = false;

    public void onCreate(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.evernoteHost = savedInstanceState.getString("evernoteHost");
            this.consumerKey = savedInstanceState.getString("consumerKey");
            this.consumerSecret = savedInstanceState.getString("consumerSecret");
            this.requestToken = savedInstanceState.getString("requestToken");
            this.requestTokenSecret = savedInstanceState.getString("requestTokenSecret");
            startedAuthentication = savedInstanceState.getBoolean("startedAuthentication");
        }
        if (this.consumerKey == null) {
            Intent intent = this.getIntent();
            this.evernoteHost = intent.getStringExtra(EXTRA_EVERNOTE_HOST);
            this.consumerKey = intent.getStringExtra(EXTRA_CONSUMER_KEY);
            this.consumerSecret = intent.getStringExtra(EXTRA_CONSUMER_SECRET);
        }
        this.setTheme(16973909);
        startedAuthentication = false;
        super.onCreate(savedInstanceState);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("evernoteHost", this.evernoteHost);
        outState.putString("consumerKey", this.consumerKey);
        outState.putString("consumerSecret", this.consumerSecret);
        outState.putString("requestToken", this.requestToken);
        outState.putString("requestTokenSecret", this.requestTokenSecret);
        outState.putBoolean("startedAuthentication", startedAuthentication);
    }

    protected void onResume() {
        super.onResume();
        if (this.evernoteHost == null || this.consumerKey == null || this.consumerSecret == null) {
            this.finish();
            return;
        }
        if (!startedAuthentication) {
            this.beginAuthentication();
            startedAuthentication = true;
        } else if (!this.receivedCallback) {
            authToken = null;
            this.finish();
            return;
        }
    }

    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        Uri uri = intent.getData();
        if (uri != null && uri.getScheme().equals(this.getCallbackScheme())) {
            authToken = this.completeAuth(uri);
            this.receivedCallback = true;
            this.finish();
        }
    }

    private String getCallbackScheme() {
        return "en-" + this.consumerKey;
    }

    private OAuthService createService() {
        Class<EvernoteApi> apiClass = EvernoteApi.class;
        if (this.evernoteHost.equals("sandbox.evernote.com")) {
            apiClass = EvernoteApi.Sandbox.class;
        }
        return new ServiceBuilder().provider(apiClass).apiKey(this.consumerKey).apiSecret(this.consumerSecret).callback(String.valueOf(this.getCallbackScheme()) + "://callback").build();
    }

    private void beginAuthentication() {
        try {
            OAuthService service = this.createService();
            Log.i((String)TAG, (String)"Retrieving OAuth request token...");
            Token requestToken = service.getRequestToken();
            this.requestToken = requestToken.getToken();
            this.requestTokenSecret = requestToken.getSecret();
            Log.i((String)TAG, (String)"Redirecting user for authorization...");
            String url = service.getAuthorizationUrl(requestToken);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.startActivity(intent);
        }
        catch (OAuthException oax) {
            Log.e((String)TAG, (String)"Failed to obtain OAuth request token", (Throwable)oax);
            this.finish();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Failed to obtain OAuth request token", (Throwable)ex);
            this.finish();
        }
    }

    private EvernoteAuthToken completeAuth(Uri uri) {
        EvernoteAuthToken accessToken = null;
        if (this.requestToken != null) {
            OAuthService service = this.createService();
            String verifierString = uri.getQueryParameter("oauth_verifier");
            if (verifierString == null || verifierString.length() == 0) {
                Log.i((String)TAG, (String)"User did not authorize access");
            } else {
                Verifier verifier = new Verifier(verifierString);
                Log.i((String)TAG, (String)"Retrieving OAuth access token...");
                try {
                    Token reqToken = new Token(this.requestToken, this.requestTokenSecret);
                    accessToken = new EvernoteAuthToken(service.getAccessToken(reqToken, verifier));
                }
                catch (OAuthException oax) {
                    Log.e((String)TAG, (String)"Failed to obtain OAuth access token", (Throwable)oax);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)"Failed to obtain OAuth access token", (Throwable)ex);
                }
            }
        } else {
            Log.d((String)TAG, (String)"Unable to retrieve OAuth access token, no request token");
        }
        return accessToken;
    }
}

