package com.yuji.ef.utility;

import android.os.Handler;
import android.os.Message;

import com.yuji.ef.SettingActivity;
import com.yuji.ef.common.Constant;
import com.yuji.ef.dao.LockDao;
import com.yuji.ef.task.NoteUpdateTask;

public class LockHandler {
	private final static int N = 32;
	private LockDao dao = (LockDao) LockDao.getInstance();
	private boolean isCanceled = false;
	
	public void lock(final LockListener target, final String key,
			final boolean wait, final boolean isUnlock) {
		final Handler handler = new Handler() {
			public void handleMessage(Message msg) {
				target.sendLockResult(msg.what != 0);
			}
		};
		Thread t = new Thread(new Runnable() {
			@Override
			public void run() {
				// #29573
				if (isUnlock){
					// 他のロックは解除せずでよいか(プロセスのキルでロックが残る場合)
					// →サービスは、setNextTimeを基準にロックを解除
					dao.unlock(SettingActivity.class, Constant.LOCK_UPDATE_NOTE);
					dao.unlock(NoteUpdateTask.LOCK_OBJ, Constant.LOCK_UPDATE_NOTE);
				}
				
				int n = 1;
				while (!isCanceled) {
					boolean lock = dao.lock(target, key);

					if (wait) {
						if (!lock) {
							String info = dao.getLockInfo();
							Debug.d(this, info);
							try {
								Thread.sleep(n * 1000);
							} catch (InterruptedException e) {
								;
							}
							if (n < N){
								n *= 2;
							}
							continue;
						}
					}
					handler.sendEmptyMessage(lock ? 1 : 0);
					break;
				}
			}
		});
		t.start();
	}
	
	public void cancel(){
		isCanceled = true;
	}
}
