package com.yuji.ef.utility;

import java.util.Calendar;

import android.content.Context;
import android.text.format.DateUtils;

public class DateUtil {
	public static long next() {
		Calendar cal = Calendar.getInstance();
		int h = cal.get(Calendar.HOUR_OF_DAY);
		int m = cal.get(Calendar.MINUTE);
		int s = cal.get(Calendar.SECOND);

		m = (m / 10) * 10;
		s = 0;

		cal.set(Calendar.MINUTE, m);
		cal.set(Calendar.SECOND, s);
		cal.add(Calendar.MINUTE, 10);

		return cal.getTimeInMillis();
	}

	public static long next(int h, int m, int s, int ds) {
		Calendar cal;

		cal = Calendar.getInstance();
		cal.add(Calendar.SECOND, ds);
		long nt = cal.getTimeInMillis();

		cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, h);
		cal.set(Calendar.MINUTE, m);
		cal.set(Calendar.SECOND, s);
		long t = cal.getTimeInMillis();

		if (t < nt) {
			cal.add(Calendar.DATE, 1);
		}

		return cal.getTimeInMillis();
	}

	public static long getTime(int h, int m, int s) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, h);
		cal.set(Calendar.MINUTE, m);
		cal.set(Calendar.SECOND, s);

		return cal.getTimeInMillis();
	}

	public static String toDateString(Context context, long t) {
		String str = DateUtils.formatDateTime(context, t,
				DateUtils.FORMAT_SHOW_DATE | DateUtils.FORMAT_SHOW_TIME);
		return str;
	}
}
