package com.yuji.ef.exception;

import android.content.Context;
import android.content.Intent;
import android.widget.Toast;

import com.yuji.ef.Initialize;
import com.yuji.ef.common.Constant;

public class EfException extends Exception {
	/**
	 * 
	 */
	private static final long serialVersionUID = 2248123315072811891L;
	private EfError error;

	public EfException(EfError error) {
		this.error = error;
	}

	public EfError getError() {
		return error;
	}

	public static void msg(int id){
		msg(id, null);
	}
	
	public static void msg(int id, Exception e){
		String msg = Initialize.getContext().getString(id);
		if (e != null){
			msg += getMessageInfo(e);
		}
		msg(msg);
	}

	public static void msg(String msg){
		msg(msg, null);
	}
	
	public static void msg(String msg, Exception e){
		if (e != null){
			msg += getMessageInfo(e);
		}
		Intent intent = new Intent(Constant.ACTION_MESSAGE);
		intent.putExtra(Constant.ACTION_MESSAGE_MESSAGE, msg);
		Initialize.getContext().sendBroadcast(intent);
	}

	public static void msg(Context context, String msg) {
		msg(context, msg, null);
	}
	
	public static void msg(Context context, String msg, Exception e) {
		if (e != null){
			msg += getMessageInfo(e);
		}
		Toast.makeText(context, msg, Toast.LENGTH_LONG).show();
	}
	
	public static String getMessageInfo(Exception e){
		StackTraceElement[] st = e.getStackTrace();
		StackTraceElement elem = st[0];
		String clazz = elem.getClassName();
		String method = elem.getMethodName();
		int line = elem.getLineNumber();
		
		return " [" + clazz + " " + method + "() " + line + "]";
	}
}
