package com.yuji.ef.dao;

public class NodeFactory {
	private static NodeFactory instance = null;

	public static NodeFactory getInstance(){
		if (instance == null){
			instance = new NodeFactory();
		}
		return instance;
	}	
	
	private NodeFactory(){

	}

	public Node create(long id, int type, String guid, long parent, String name, String children, int status, boolean isSelected){
		Node node = null;
		
		switch (type){
		case Node.TYPE_ROOT:
			node = new RootNode(name, null, children, status);
			break;
		case Node.TYPE_BOOK:
		case Node.TYPE_DIR:
			node = new DirNode(name, null, children, status);
			break;
		case Node.TYPE_NOTE:
			node = new FileNode(name, null);
			break;
		default:
			break;
		}
		if (node != null){
			node.setId(id);
			node.setParent(parent);
			node.setGuid(guid);
			node.setSelected(isSelected);
		}
		
		return node;
	}
}
