package com.yuji.ef;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PorterDuff.Mode;
import android.graphics.Rect;
import android.view.Gravity;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

public class LabelIconView extends LinearLayout {
	private int initX = 0;
	private int initY = 0;

	// private LabelIconView statusImageView = null;
	private StatusIconView statusImageView = null;
	private ImageView imageView = null;
	private TextView textView = null;
	private long id = -1;

	public LabelIconView(Context context) {
		super(context);
		setGravity(Gravity.CENTER);
	}

	public long getNodeId() {
		return id;
	}

	public void init(int x, int y, Bitmap bmp1, Bitmap bmp2, String text) {
		init(x, y);
		Context context = this.getContext();

		if (statusImageView != null) {
			this.removeView(statusImageView);
		}
		if (imageView != null) {
			this.removeView(imageView);
		}
		if (textView != null) {
			this.removeView(textView);
		}

		if (bmp1 != null) {
			statusImageView = new StatusIconView(context, this);
			statusImageView.init(0, 0, null, bmp1, null);
		}

		imageView = new ImageView(context);
		imageView.setImageBitmap(bmp2);

		if (text != null) {
			textView = new TextView(context);
			textView.setTextSize(bmp2.getHeight() / 6);
			textView.setLines(1);
			textView.setText(text);
		}

		if (statusImageView != null) {
			addView(statusImageView);
		}
		addView(imageView);
		if (textView != null) {
			addView(textView);
		}
	}

	public LabelIconView getSelectedView(int x, int y) {
		if (statusImageView != null) {
			Rect rect = new Rect();

			statusImageView.getHitRect(rect);
			if (rect.contains(x, y)) {
				return statusImageView;
			}
		}
		return this;
	}

	public void setNodeId(long id) {
		this.id = id;
		if (statusImageView != null) {
			statusImageView.setNodeId(id);
		}
	}

	public int getInitX() {
		return initX;
	}

	public int getInitY() {
		return initY;
	}

	public LabelIconView getStatusImageView() {
		return statusImageView;
	}

	public void init(int x, int y) {
		initX = x;
		initY = y;
	}

	public void setAlpha(int alpha) {
		imageView.setAlpha(alpha);
	}

	public void setColorFilter(int color, Mode mode) {
		imageView.setColorFilter(color, mode);
	}

	public void clearColorFilter() {
		imageView.clearColorFilter();
	}
}
