package com.yuji.ef;

import java.util.List;

import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ListView;

import com.yuji.ef.dao.Node;
import com.yuji.ef.dao.NodeCacheDao;
import com.yuji.ef.dao.NodeDao;
import com.yuji.ef.exception.EfException;
import com.yuji.ef.utility.BaseActivity;
import com.yuji.ef.utility.Debug;

public class BookListActivity extends BaseActivity {
	private ListView listView;
	private List<Node> list;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.book_list);

		try {
			listView = (ListView) findViewById(R.id.bookList);
			Button closeButton = (Button) findViewById(R.id.bookCloseButton);

			NodeDao dao = (NodeDao)NodeCacheDao.getInstance();
			list = dao.searchBook();
			BookListViewArrayAdapter adapter = new BookListViewArrayAdapter(
					this, android.R.layout.simple_list_item_1, list);
			listView.setAdapter(adapter);

			listView.setOnItemClickListener(new OnItemClickListener() {
				public void onItemClick(AdapterView<?> parent, View view,
						int position, long id) {
					Node item = list.get(position);
					 boolean selected = item.isSelected();
					
					selected = !selected;
					item.setSelected(selected);

					CheckBox checkbox = (CheckBox) view
							.findViewById(R.id.checkBox);
					checkbox.setChecked(selected);

					try {
						NodeDao dao = (NodeDao)NodeCacheDao.getInstance();
						dao.updateSelected(item, selected);
					}
					catch (Exception e){
						EfException.msg(R.string.ErrorSystem, e);
					}
				}
			});

			closeButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					BookListActivity.this.finish();
				}
			});
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}
}
