using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using Bram.NxtSharp;
using Bram.Utilities;

namespace Bram.NXTRemote {

	/// <summary>
	/// This application acts as a Mindstorms NXT remote control.
	/// 
	/// The motors can be controlled using the three motor controls
	/// on the top part of the form. You can also control the motors
	/// using the keyboard.
	/// 
	/// The sensors are continuously polled using the AutoPoll feature
	/// </summary>
	public partial class RemoteForm : Form {
		public RemoteForm() {
			InitializeComponent();
		}

		protected override void OnLoad(EventArgs e) {
			base.OnLoad(e);

			nxtBrick.Connect();
			updateBatteryLevel();
		}

		protected override void OnClosing(CancelEventArgs e) {
			nxtBrick.Disconnect();
			base.OnClosing(e);
		}

		private void nxtPressureSensor1_Polled(NxtSensor sensor) {
			Invoke((MethodInvoker)delegate() {
				lblPressed.Text = nxtPressureSensor1.IsPressed.ToString();
			});
		}

		private void nxtSoundSensor1_ValueChanged(NxtSensor sensor) {
			Invoke((MethodInvoker)delegate() {
				valSound.Value = (int)Util.Clamp(nxtSoundSensor1.Value, 0, 100);
			});
		}

		private void nxtLightSensor1_ValueChanged(NxtSensor sensor) {
			Invoke((MethodInvoker)delegate() {
				valLight.Value = (int)Util.Clamp(nxtLightSensor1.Value, 0, 100);
			});
		}

		private void nxtSonar1_ValueChanged(NxtSensor sensor) {
			Invoke((MethodInvoker)delegate() {
				lblDistance.Text = sensor.RawValue.ToString();
			});
		}

		private void timerBatteryLevel_Tick(object sender, EventArgs e) {
			updateBatteryLevel();
		}

		void updateBatteryLevel() {
			timerBatteryLevel.Enabled = true;
			int level = nxtBrick.Comm.GetBatteryLevel();
			level = level / 100;
			lblBatteryStatus.Text = "Battery level: " + (level / 10) + "." + (level % 10) + "V";
		}
	}
}