///////////////////////////////////////////////////////////
//  OnOff.h
//  Implementation of the Class OnOff
//  Created on:      11-7-2009 20:33:36
//  Original author: m-usami
///////////////////////////////////////////////////////////

#ifndef ONOFF_H__
#define ONOFF_H__

#include "ecrobot_types.h"
#include "ControlAlgorithm.h"

class OnOff : public ControlAlgorithm {
	/// 萔`
	static const S16 UPPER = 690;
	static const S16 LOWER = 610;
	static const S16 THRESHOLD = ((UPPER + LOWER) / 2);

	static const S8 MAX = 100;	// l̍ől
	static const S8 MIN = -100;	// l̍ŏl

	S8 getDirectionCommand(S16 light);
	S8 getVelocityCommand(S16 light);
public:
	OnOff(LightSensorValue& bb);
	virtual ~OnOff();

	virtual void getCommand(S16 light, S8& direction, S8& velocity);
};

#endif // ONOFF_H__
