///////////////////////////////////////////////////////////
//  IDTech.cpp
//  Implementation of the Class IDTech
//  Created on:      11-7-2009 20:33:34
//  Original author: Administrator
///////////////////////////////////////////////////////////

#include "IDTech.h"


/**
 * RXgN^
 * 	WCZT[A[^[̃CX^XZbg
 */
IDTech::IDTech(const ecrobot::Nxt& nxt, const ecrobot::GyroSensor& gyro,
		ecrobot::Motor& leftMotor, ecrobot::Motor& rightMotor,
		LightSensorValue& bb) :
	m_Nxt(nxt), m_GyroSensor(gyro),
	m_LeftMotor(leftMotor), m_RightMotor(rightMotor),
	m_GyroSensorOffset(USER_GYRO_OFFSET), m_BlackBoard(bb) {
	
	balance_init();
}



IDTech::~IDTech(){

}

void IDTech::init() {
}

void IDTech::balance(){
	balance_control(
		static_cast<F32>(m_Velocity),  // Oi
		static_cast<F32>(m_Direction), // 񖽗
		static_cast<F32>(m_GyroSensor.get()),
		static_cast<F32>(m_GyroSensorOffset),
		static_cast<F32>(m_LeftMotor.getCount()),
		static_cast<F32>(m_RightMotor.getCount()),
		static_cast<F32>(m_Nxt.getBattMv()),
		&m_LeftMotorPWM,
		&m_RightMotorPWM);

	m_LeftMotor.setPWM(m_LeftMotorPWM);
	m_RightMotor.setPWM(m_RightMotorPWM);

	m_BlackBoard.setMoterDriveValue(0, m_RightMotorPWM);
	m_BlackBoard.setMoterDriveValue(1, m_LeftMotorPWM);
}

void IDTech::drive() {
}
