#ifndef ICONTROL_H_
#define ICONTROL_H_


#include "ecrobot_types.h"

extern "C" {
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
};

#include "Globals.h"

// #include "Clock.h"
// extern ecrobot::Clock clock;

class IControl
{
public:
	IControl();

	virtual ~IControl();

	// s[v
	virtual void execute();

	// X^[gȌ(Lu[VȂǁj
	virtual void ready();

	// 񓯊s^̎sC^[tFCX
	void start( );

	// 񓯊s^̒~C^[tFCX
	void cancel();

	// 񓯊s^̊`FbNC^[tFCX
	bool isCompleted();

	// 񓯊s^̊Jn҂C^[tFCX
	void waitStart( TaskType,TaskType, EventMaskType, EventMaskType, EventMaskType, EventMaskType );

	U16 getStatus();
	void setStatus( U16 );

	enum CONTROLS
	{
		BLACKBOARD_CONTROLLER,		// BlackBoardp̃Rg[B
		RALLY_DRIVER,				// Zsp̃Rg[B
		COUNT
	};

protected:

	// ^XN̊˗^XNɒʒmB
	void completed();

	// ^XNɒ~ʒmĂ邩`FbNB
	bool isCanceled();

	void waitHeartBeat();

private:
	TaskType mMyTask;
	TaskType mClientTask;
	EventMaskType mMyExecuteEvent;
	EventMaskType mMyCancelEvent;
	EventMaskType mCompletedEvent;
	EventMaskType mHeartBeat;
	
	U16 mStatus;
	


};

#endif

