///////////////////////////////////////////////////////////
//  ControlAlgorithm.cpp
//  Implementation of the Class ControlAlgorithm
//  Created on:      11-7-2009 21:15:35
//  Original author: m-usami
///////////////////////////////////////////////////////////

#include "ControlAlgorithm.h"

const S8 ControlAlgorithm::LEFT_EDGE;
const S8 ControlAlgorithm::RIGHT_EDGE;
const S8 ControlAlgorithm::FORWARD;
const S8 ControlAlgorithm::BACKWARD;

ControlAlgorithm::ControlAlgorithm(LightSensorValue& bb) :
	edge_(LEFT_EDGE), forward_(FORWARD), blackboard_(bb) {
}

ControlAlgorithm::~ControlAlgorithm() {
}

/**
 * ̃ftHg
 * 	Ȃ
 */
void ControlAlgorithm::init() {
}

/**
 * Gbas
 */
void ControlAlgorithm::leftEdge() {
	edge_ = LEFT_EDGE;
}

/**
 * EGbas
 */
void ControlAlgorithm::rightEdge() {
	edge_ = RIGHT_EDGE;
}

/**
 * Ois
 */
void ControlAlgorithm::forward() {
	forward_ = FORWARD;
}

/**
 * ޑs
 */
void ControlAlgorithm::backward() {
	forward_ = BACKWARD;
}
