///////////////////////////////////////////////////////////
//  ConcreteDTech.h
//  Implementation of the Class ConcreteDTech
//  Created on:      11-7-2009 20:33:32
//  Original author: Administrator
///////////////////////////////////////////////////////////

#if !defined(EA_AAE9C900_AAB2_4a6d_A478_A1ABC1A6471B__INCLUDED_)
#define EA_AAE9C900_AAB2_4a6d_A478_A1ABC1A6471B__INCLUDED_

#include "ecrobot_types.h"
#include "IDTech.h"
#include "ControlAlgorithm.h"
#include "PID.h"

class ConcreteDTech : public IDTech {
	enum {
		ROTATE = 0,
		STOP
	};
	static const U16 TIMER_LIMIT = (2 * 1000) / 4;
	ControlAlgorithm& m_Algorithm;		// ASY

	S16 m_Light;
	U16 timer_;
	S8  state_;

	void driveRotate();
	void driveStop();
public:
	ConcreteDTech(const ecrobot::Nxt& nxt, const ecrobot::GyroSensor& gyro,
			ecrobot::Motor& leftMotor, ecrobot::Motor& rightMotor,
			LightSensorValue& bb, ControlAlgorithm& pid);
	virtual ~ConcreteDTech();

	virtual void init();
	virtual void drive();
};

#endif // !defined(EA_AAE9C900_AAB2_4a6d_A478_A1ABC1A6471B__INCLUDED_)
