///////////////////////////////////////////////////////////
//  ConcreteDTech.cpp
//  Implementation of the Class ConcreteDTech
//  Created on:      11-7-2009 20:33:33
//  Original author: Administrator
///////////////////////////////////////////////////////////

#include "ConcreteDTech.h"


ConcreteDTech::ConcreteDTech(const ecrobot::Nxt& nxt,
		const ecrobot::GyroSensor& gyro,
		ecrobot::Motor& leftMotor, ecrobot::Motor& rightMotor,
		LightSensorValue& bb, ControlAlgorithm& algorithm) :
			IDTech(nxt, gyro, leftMotor, rightMotor, bb), 
			m_Algorithm(algorithm),
			timer_(0), state_(ROTATE) {
}

ConcreteDTech::~ConcreteDTech(){

}

void ConcreteDTech::init() {
	m_Algorithm.leftEdge();
	m_Algorithm.forward();
}

void ConcreteDTech::driveRotate() {
	// ZT[l𓾂
//	m_Light = m_BlackBoard.inspect();
	// lƑxl𓾂
//	m_Algorithm.getCommand(m_Light, m_Direction, m_Velocity);
	// oXs
	m_Velocity = 0;
	m_Direction = 100;
	balance();
}

void ConcreteDTech::driveStop() {
	m_LeftMotor.setBrake(true);
	m_RightMotor.setBrake(true);
}

void ConcreteDTech::drive() {
	switch(state_) {
	case ROTATE:
		timer_++;
		if (timer_ > TIMER_LIMIT) {
			state_ = STOP;
		}
		driveRotate();
		break;
	case STOP:
	default:
		driveStop();
		break;
	}
}
