#include "Lcd.h"
#include "Nxt.h"
#include "Clock.h"
#include "Port.h"
#include "Bluetooth.h"
#include "Motor.h"
#include "GyroSensor.h"
#include "DAQ.h"


#include "LightSensor.h"
#include "TouchSensor.h"
// #include "TouchStarter.h"
// #include "BlackBoardFactory.h"
#include "LightSensorValue.h"

#include "ecrobot_interface.h"

//----------------------------------------------------
#ifndef GLOBALS
#define GLOBALS

//----------------------------------------------------
// GLOBAL 錾p OOIɂ́Aʃt@CɂׂB
//----------------------------------------------------


using namespace ecrobot;


LightSensor lightsensor(PORT_3);
TouchSensor touch(PORT_1);
Clock clock;
Lcd lcd;
Nxt nxt;
Motor leftMotor(PORT_C);
Motor rightMotor(PORT_B);
GyroSensor	gyro(PORT_4);
Bluetooth bt;
Daq daq(bt);

LightSensorValue	blackboard(lightsensor);


#else
//----------------------------------------------------
// extern 錾p
//----------------------------------------------------

using namespace ecrobot;

extern LightSensor lightsensor;
extern TouchSensor touch;
extern Clock clock;
extern Lcd lcd;
extern Nxt nxt;
extern Motor leftMotor;
extern Motor rightMotor;
extern GyroSensor	gyro;
extern Bluetooth bt;
extern Daq daq;
extern LightSensorValue	blackboard;


#endif

