/* sample.cpp for TOPPERS/ATK(OSEK) */ 

// ECRobot++ API
#include "Lcd.h"
#include "Nxt.h"
#include "Clock.h"
#include "LightSensor.h"
#include "Port.h"
using namespace ecrobot;

extern "C"
{
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"


// nxtOSEK hook to be invoked from an ISR in category 2
void user_1ms_isr_type2(void){}

// 
void White_View(void);
void Black_View(void);
void Gray_View(void);

//ZT[
LightSensor lightsensor(PORT_3);

TASK(TaskMain)
{
	Lcd lcd;
        Nxt nxt;
	Clock clock;
	int i = 585;

	nxt.getButtons();
	lcd.clear();
	lcd.putf("s", "Gyro");
	lcd.putf("n", 1);
	lcd.putf("d", i);
	lcd.disp();
	clock.wait(1000);
	
	while(1){
		if(Nxt::ENTR_ON  == nxt.getButtons()){
			lcd.clear();
			lcd.putf("s", "Gyro");
                	lcd.putf("n", 1);
			lcd.putf("d", i++);
			lcd.disp();
			clock.wait(1000);
		}else if(Nxt::RUN_ON == nxt.getButtons()){
			clock.wait(1000);
			White_View();
		}else if(Nxt::RUN_ENTR_ON  == nxt.getButtons()){
			i = 0;
			lcd.clear();
			lcd.putf("s", "Gyro");
                	lcd.putf("n", 1);
			lcd.putf("d", i);
			lcd.disp();
			clock.wait(1000);
		}
	}

}




/**/
void White_View(void){

	Lcd lcd;
        Nxt nxt;
	Clock clock;
	int i=0;

	lcd.clear();
	lcd.putf("s", "White");
	lcd.putf("n", 1);
	lcd.disp();
	clock.wait(1000);

	while(1){
		if(Nxt::ENTR_ON  == nxt.getButtons()){
			clock.wait(1000);
			BlackBourd.setLightSenserWhite(i);
			Black_View();
			
		}else if(Nxt::RUN_ON == nxt.getButtons()){
			clock.wait(1000);
			Black_View();
		}else if(Nxt::RUN_ENTR_ON  == nxt.getButtons()){
			clock.wait(1000);
		}else {
			i = lightsensor.getBrightness();
			lcd.clear();
			lcd.putf("s", "White");
			lcd.putf("n", 1);
			lcd.putf("d", i);
			lcd.disp();
			clock.wait(200);
		}

	}

}

/**/
void Black_View(void){

	Lcd lcd;
        Nxt nxt;
	Clock clock;
	int i=0;

	lcd.clear();
	lcd.putf("s", "Black");
	lcd.disp();
	clock.wait(1000);

	while(1){
		if(Nxt::ENTR_ON  == nxt.getButtons()){
			clock.wait(1000);
			Gray_View();
		}else if(Nxt::RUN_ON == nxt.getButtons()){
			clock.wait(1000);
			Gray_View();
		}else if(Nxt::RUN_ENTR_ON  == nxt.getButtons()){
			clock.wait(1000);
		}else {
			i = lightsensor.getBrightness();
			lcd.clear();
			lcd.putf("s", "Black");
			lcd.putf("n", 1);
			lcd.putf("d", i);
			lcd.disp();
			clock.wait(200);
		}

	}
}

/*O[*/
void Gray_View(void){

	Lcd lcd;
        Nxt nxt;
	Clock clock;
	int i=0;

	lcd.clear();
	lcd.putf("s", "Gray");
	lcd.disp();
	clock.wait(1000);

	while(1){
		if(Nxt::ENTR_ON  == nxt.getButtons()){
			clock.wait(1000);
			White_View();
		}else if(Nxt::RUN_ON == nxt.getButtons()){
			clock.wait(1000);
			White_View();
		}else if(Nxt::RUN_ENTR_ON  == nxt.getButtons()){
			clock.wait(1000);
		}else {
			i = lightsensor.getBrightness();
			lcd.clear();
			lcd.putf("s", "Gray");
			lcd.putf("n", 1);
			lcd.putf("d", i);
			lcd.disp();
			clock.wait(200);
		}

	}

}


}
