///////////////////////////////////////////////////////////
//  CalibrateController.cpp
//  Implementation of the Class CalibrateController
//  Created on:      12-7-2009 9:29:41
//  Original author: m-inui
///////////////////////////////////////////////////////////

#include "CalibrateController.h"
#include "UIFactory.h"
#include "UIController.h"

#include "LightSensor.h"
#include "TouchSensor.h"
#include "Lcd.h"
#include "Clock.h"
#include "Test.h"

const char WHITE[] = "White";
const char BLACK[] = "Black";
const char GRAY[]  = "Gray";
const char CMPLT[]= "Complete";

using namespace ecrobot;
//光センサー
LightSensor lightsensor(PORT_3);
//タッチセンサー
TouchSensor touchsensor(PORT_1);

CalibrateController::CalibrateController(CalibrateModel* calibrateModel):m_CalibrateModel(calibrateModel){

}


CalibrateController::~CalibrateController(){
}


void CalibrateController::notifyChange(Nxt::eButton button){
	CalibrateData data = m_CalibrateModel->getData();
	Lcd lcd;
	Clock clock;

	switch(button){
	case Nxt::ENTR_ON:
		break;
	case Nxt::RUN_ON:
		break;
	case Nxt::RUN_ENTR_ON:
		m_nextState = m_UIFactory->createMenu();
		break;
	case Nxt::BUTTONS_OFF:
		data.m_Int = lightsensor.getBrightness();
		if(touchsensor.isPressed()){
//			switch(data.m_String){
//			case WHITE:
				/*BlackBourd.setLightSenserWhite(data.m_Int);*/
//				data.m_String = BLACK;
//			case BLACK:
				/*BlackBourd.setLightSenserBlack(data.m_Int);*/
//				data.m_String = GRAY;
//			case GRAY:
				/*BlackBourd.setLightSenserGRAY(data.m_Int);*/
//				data.m_String = CMPLT;
//			default:;
//			}
		}
		m_CalibrateModel->setData(data);
		break;
	default:;
	}
	m_CalibrateModel->service();
}


void CalibrateController::update(){
	m_UIController->change(m_nextState);
}


void CalibrateController::initialization(){
	CalibrateData calibrateData;
	calibrateData.m_Int = 0;
	calibrateData.m_String = WHITE;
	m_CalibrateModel->setData(calibrateData);
}

