///////////////////////////////////////////////////////////
//  Observer.h
//  Implementation of the Class Observer
//  Created on:      12-7-2009 9:29:45
//  Original author: m-inui
///////////////////////////////////////////////////////////

#if !defined(TEST_)
#define TEST_

#include "Lcd.h"
#include "Speaker.h"
#include "Clock.h"

using namespace ecrobot;

class Test
{

public:
	Test(){}
	Test(U32 freq, U32 duration, U32 volume){
		tone(freq,duration,volume);
	}
	Test(const char string[]){
		disp(string);
	}
	Test(const char string[],int cursor){
		disp(string,cursor);
	}
	Test(int value){
		disp(value);
	}
	Test(int value,int cursor){
		disp(value,cursor);
	}
	virtual ~Test(){}
	virtual void disp(const char string[]){
		m_Lcd.putf("s",string);
		m_Lcd.disp();
	}
	virtual void disp(const char string[],int cursor){
		m_Lcd.cursor(0,cursor);
		disp(string);
	}
	virtual void disp(int value){
		m_Lcd.putf("d",value);
		m_Lcd.disp();
	}
	virtual void disp(int value,int cursor){
		m_Lcd.cursor(0,cursor);
		disp(value);
	}
	virtual void tone(U32 freq, U32 duration, U32 volume){
		m_Speaker.playTone(freq,duration,volume);
	}

protected:
	Lcd     m_Lcd;
	Speaker m_Speaker;
};
#endif // !defined(TEST_)
