
//ZT[
// LightSensor lightsensor(PORT_3);


#include "Globals.h"
#include "RunMenu.h"
#include "IControl.h"
#include "ControlFactory.h"

extern ControlFactory factoryControl;

extern const TaskType TaskUI;
extern const EventMaskType EV_UI_HEARTBEAT;
extern const EventMaskType EV_USER_OPERATION;
extern const EventMaskType EV_CONTROL_START_RALLY;
extern const EventMaskType EV_CONTROL_COMPLETE;
extern const EventMaskType EV_CONTROL_CANCEL;
extern const EventMaskType EV_RUN_HEARTBEAT;


RunMenu::RunMenu()
{
}

RunMenu::~RunMenu()
{
}
	
void  RunMenu::disp()
{
	IControl* pControl = factoryControl.getControl(IControl::RALLY_DRIVER);

	enum
	{
		STATUS_WAITING,
		STATUS_EXECUTING,
		STATUS_CANCELING,
		STATUS_STOPPED
	};

	// sȌ
	pControl->ready();

	U8	status = STATUS_WAITING;
	EventMaskType eventAll;

	lcd.clear();
	lcd.putf("sn", "Start for Push sw" );
	lcd.disp();

	// ̎sB
	for(;;)
	{
		// GUI̍XV^C~O̎擾B
		WaitEvent( EV_UI_HEARTBEAT );

		ClearEvent( EV_UI_HEARTBEAT );

		// [U[Iy[VL̃`FbNB
		GetEvent( TaskUI, &eventAll );

		if(( eventAll & EV_USER_OPERATION) == EV_USER_OPERATION )
		{
			// {^ꂽꍇB
			ClearEvent( EV_USER_OPERATION );

			if( status == STATUS_WAITING )
			{
				// ҂̏ԂŁA{^ꂽ̂ŁA
				// sJnB execute()start()ɕύXB
				pControl->start();
				status = STATUS_EXECUTING;
				lcd.cursor(0, 0);
				lcd.putf("sn", "starting        " );
			}
			else if( status == STATUS_EXECUTING )
			{
				// sɃ{^ꂽ̂ŁALZB
				pControl->cancel();
				status = STATUS_CANCELING;
				lcd.cursor(0, 0);
				lcd.putf("sn", "canceling       " );
			}
		}
		else
		{
			// ݂̏Ԃɍ킹\邾B
			if( status == STATUS_EXECUTING ||  status == STATUS_CANCELING )
			{
				if( pControl->isCompleted() )
				{
					lcd.cursor(0, 0);
					lcd.putf("sn", "stopped         " );
					status = STATUS_STOPPED;
				}
				else
				{
					// oldData = pControl->getStatus();
					// lcd.cursor(0, 3);
					// lcd.putf("dn", oldData );
				}
				
			}
		}

		// \XV
		lcd.disp();
		
		if( status == STATUS_STOPPED )
		{
			// ƔǁAI/ĊJ\pB

			lcd.cursor(0, 0);
			lcd.putf("sn", "waiting         " );
			lcd.disp();

			clock.sleep(1000);
			
			status = STATUS_WAITING;

			break;
		}
	}
}


