namespace app.directives {
    export class Option implements ng.IDirective {

        public restrict: string;
        public replace: boolean;
        public templateUrl: string;
        public bindToController: Object;
        public controller: string;
        public controllerAs: string;
        public scope: boolean;

        /** 
         * constructor
         *
         * @param
         */
        constructor() {
            this.restrict = 'E';
            this.replace = true;
            this.controller = 'optionController';
            this.bindToController = {
                info: '=',
                files: '='
            };
            this.scope = true;
            this.templateUrl = 'templates/option.html';
            this.controllerAs = 'ctrl';
        }

        /**
         * instance生成
         * @returns {function(): HeaderMenu}
         * @constructor
         */
        public static Factory(): ng.IDirectiveFactory {
            var directive = () => {
            return new Option();
            };
            directive.$inject = [];
            return directive;
        }
    }

    export class OptionController {

        public static $inject = [];

        private info: declares.IOption;

        constructor() {
            var controller = this;

            // データバインディングしているarg.inputに
            // OptionControlFileに記された初期値(arg.initialValue)を代入
            angular.forEach(controller.info.arg, (arg) => {
                if(arg.initialValue) {
                    if(arg.formType === 'number') {
                        arg.input = parseInt(arg.initialValue);
                    } else {
                        arg.input = arg.initialValue;
                    }
                }
            });
        }
    } 
}
