namespace app.directives {

    export class Directory implements ng.IDirective {

        public restrict: string;
        public replace: boolean;
        public templateUrl: string;
        private fileInfo: declares.IFileInfo;
        public controller: string;
        public controllerAs: string;
        public bindToController: Object;

        /**
         * constructor
         *
         * @param 
         */
        constructor() {
            this.restrict = 'E';
            this.replace = true;
            this.controller = 'directoryController';
            this.controllerAs = 'ctrl';
            this.bindToController = {
                info: '=',
                add: '&',
                list: '=',
                files: '='
            };
            this.templateUrl = 'templates/directory.html';
        }

        /**
         * instance生成
         * @returns {function(): HeaderMenu}
         * @constructor
         */
        public static Factory(): ng.IDirectiveFactory {
            var directive = () => {
            return new Directory();
            };
            return directive;
        }
    }

    export class DirectoryController {

        public static $inject = ['APIEndPoint', '$scope'];

        // From parent directive bindToController property
        public info: declares.IDirectoryInfo;
        public files:declares.IFileInfo[];
        public add: Function;
        public list: declares.IDirectoryInfo[];

        constructor(private APIEndPoint: services.APIEndPoint, private $scope: ng.IScope) {
            var controller = this;

            this.APIEndPoint
                .getFiles(this.info.fileId)
                .$promise
                .then((result) => {
                    if(result.status === 'success') {
                        controller.files = result.info;
                        angular.forEach(result.info, (file) => {
                            if(file.fileType === '0') {
                                var o = file;
                                if(controller.info.path === '/') {
                                    o.path = '/' + file.name;
                                } else {
                                    o.path = controller.info.path + '/' + file.name;
                                }

                                controller.add()(o, controller.list);
                            }
                        });
                    };
                });
        }
    }
}
