namespace app.directives {
    export class Command implements ng.IDirective {

        public restrict: string;
        public replace: boolean;
        public templateUrl: string;
        public scope: boolean;
        public controller: string;
        public controllerAs: string;
        public bindToController: Object;

        /** 
         * constructor
         *
         * @param
         */
        constructor() {
            this.restrict = 'E';
            this.replace = true; 
            this.scope = true;
            this.controller = 'commandController';
            this.controllerAs = 'ctrl';
            this.bindToController = {
                index: '=',
                name: '=',
                remove: '&',
                list: '='
            };
            this.templateUrl = 'templates/command.html';
        }

        /**
         * instance生成
         * @returns {function(): HeaderMenu}
         * @constructor
         */
        public static Factory(): ng.IDirectiveFactory {
            var directive = () => {
                return new Command();
            };
            directive.$inject = [];
            return directive;
        }
    }

    export class CommandController {

        public static $inject = ['APIEndPoint', '$scope', 'MyModal', 'WebSocket', '$window'];

        // From parent directive bindToController property
        private index: string;
        private name: string;
        private remove: Function;
        private list: declares.CommandInfo[];
        private workspace: declares.IFileInfo;

        // property of ui.bootstrap uib-accordion directive
        private isOpen: boolean;
        private heading: string;

        // property about Option directive
        private files: any;
        private options: declares.IOption[];
        private dirs: any;
        private messages: any;

        constructor(private APIEndPoint: services.APIEndPoint, 
                    private $scope: ng.IScope, 
                    private MyModal: services.MyModal, 
                    private WebSocket: services.WebSocket,
                    private $window: ng.IWindowService
                   ) {
            var controller = this;

            // Get OptionControlFile and bind it to $scope.options
            this.APIEndPoint
            //.getOptionControlFile('mrcImageNoiseAdd')
            .getOptionControlFile(this.name)
            .$promise
            .then(function(result) {
                controller.options = result.info;
            });

            this.APIEndPoint
            .getDirectories()
            .$promise
            .then(function(result) {
                controller.dirs = result.info;
            });

            this.heading = "[" + this.index + "]: dcdFilePrint";
            this.isOpen = true;

            // When call add button at executeController, all accordion close.
            this.$scope.$on('close', () => {
                controller.isOpen = false;
            });

            this.WebSocket.on('console', function(msg) {
                console.log(msg);
                var messages = msg.split('\n');
                if(messages[0].substr(0,6) === 'Usage:') {
                    controller.messages = msg.split('\n');
                }
            });

        }

        public submit() {
            var opt = [];
            angular.forEach(this.options, (option) => {

                var obj = {
                    name: option.option,
                    arguments: []
                };

                angular.forEach(option.arg, (arg) => {
                    if(arg.input) {
                        if(typeof arg.input === 'object') {
                            obj.arguments.push(arg.input.name);
                        } else {
                            obj.arguments.push(arg.input);
                        }
                    }
                });

                if(obj.arguments.length > 0) {
                    opt.push(obj);
                }
            });

            var execObj = {
                command: this.name,
                workspace: this.workspace.fileId,
                options: opt
            };

            //console.log(JSON.stringify(execObj,null,'\t'));
            this.APIEndPoint
            .execute(JSON.stringify(execObj))
            .then((result) => {
                console.log(result);
            })
        }

        public removeMySelf(index:number) {
            this.remove()(index,this.list);
        }

        private reloadFiles() {
            var fileId = this.workspace.fileId;
            this.APIEndPoint
            .getFiles(fileId)
            .$promise
            .then((result) => { 
                var status = result.status;
                if(status === 'success') {
                    this.files = result.info;
                } else {
                    console.log(result.message);
                }
            });
        }

        public debug() {
            var div = angular.element(this.$window.document).find("div");
            var consoleTag;
            var parametersTag;
            angular.forEach(div,function(v) {
                if(v.className === "panel-body console") {
                    consoleTag = v;
                } else if(v.className === "row parameters-console") {
                    parametersTag = v;
                }
            });

            // Adjust console area from CSS styling positoning information
            var consoleHeight = parseInt(parametersTag.clientHeight.toString().replace('px','')) - 150 + 'px';
            var consoleWidth = parseInt(parametersTag.clientWidth.toString().replace('px','')) / 3 * 2 - 150 + 'px';
            consoleTag.style.height = consoleHeight;
            consoleTag.style.width = consoleWidth;
        }
        
        public help() {
            this.APIEndPoint
            .help(this.name)
            .then((result) => {
                console.log(result);
            });
        }

    } 
}
