namespace app.controllers {
    export class Execution {

        public static $inject = ['MyModal', '$scope'];

        public commandInfoList: declares.CommandInfo[];

        public page: string;

        constructor(private MyModal: services.MyModal, private $scope: ng.IScope) {
            this.commandInfoList = [];
        };

        public add() {
            // close all <uib-accordion> tag
            this.$scope.$broadcast('close');
            var commandInfoList = this.commandInfoList;
            
            // add <command> directive
            var commandInstance = this.MyModal.selectCommand();
            commandInstance
                .result
                .then(function(command) {
                    commandInfoList.push(new declares.CommandInfo(command));
                });
        }

        public open() {
            var result = this.MyModal.open('SelectCommand');
            console.log(result);
        }

        public remove(index: number, list: declares.CommandInfo[]) {
            list.splice(index, 1);

            /**
             * Commandディレクティブから実行する際にはExecution.commandInfoListの参照を取得できない。
             * ディレクティブ経由でExecution.commandInfoListの参照を取得。
             * this.commandInfoList.splice(index, 1);
             * 上記のコードは実行できない。
             * thisがremoveの呼び出し元となるため。
             */
        }

        public close() {
            console.log("close");
        }

    }
}
