#!/usr/bin/env node --harmony

'use strict';

var express = require('express'),
    config  = require('./config'),
    app     = express(),
    EventEmitter = require('events').EventEmitter,
    emitter = new EventEmitter,
    server  = require('http').Server(app)

require('./express')(app)
require('./routes')(app)

var server = app.listen(config.port, config.ip, function () {
    console.log('Zephyr listening at http://%s:%s', config.ip, config.port);
    console.log(app.get('env'))
});

var io = require('socket.io').listen(server)
require('./ws')(io)

exports = module.exports = app;
