#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  ] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 ] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-c[onfig]           configFile          ] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-t[itle]            Title               ] :Optional  :Title\n");
    fprintf(stderr, "    [-l[lMax]            llMax               ] :Optional  :llMax\n");
    fprintf(stderr, "    [-D[elRInv]          delRInv             ] :Optional  :delRInv[A]\n");
    fprintf(stderr, "    [-R[MaxInv]          RMaxInv             ] :Optional  :RMaxInv[A]\n");
    fprintf(stderr, "    [-d[elr]             delr                ] :Optional  :delr[A]\n");
    fprintf(stderr, "    [-r[Max]             rMax                ] :Optional  :rMax[A]\n");
    fprintf(stderr, "    [-f[lagOutputInfo]   flagOutputInfo      ] :Optional  :flagOutputInfo\n");
    fprintf(stderr, "    [-m[ode]             mode                ] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
