#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :Input: PDB\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :Output: MRC\n");
    fprintf(stderr, "    [-N                  Nx                  (2048      )Ny                  (2048      )] :Optional  :Input: Nx Ny [pixel]\n");
    fprintf(stderr, "    [-d                  dx                  (1.72      )dy                  (1.72      )] :Optional  :Input: dx dy [A]\n");
    fprintf(stderr, "    [-Centre             cx                  (0         )cy                  (0         )cz                  (0         )] :Optional  :Input: CentreX CentreY [A]\n");
    fprintf(stderr, "    [-n                  nx                  (64        )ny                  (64        )] :Optional  :Input: nx ny for subimage [pixel]\n");
    fprintf(stderr, "    [-kV                 kV                  (200.      )] :Optional  :kV \n");
    fprintf(stderr, "    [-Cs                 Cs                  (1.7       )] :Optional  :Cs \n");
    fprintf(stderr, "    [-d[e]f[ocus]        Defocus             (10000     )] :Optional  :Defocus [A] at z = 0\n");
    fprintf(stderr, "    [-A[overP]           AoverP              (0.07      )] :Optional  :AoverP\n");
    fprintf(stderr, "    [-Ain                Ain                 (0.2       )] :Optional  :Beta: IlluminationAngle [mrad]\n");
    fprintf(stderr, "    [-ctfMode            ctfMode             (33        )] :Optional  :ctfMode\n");
    fprintf(stderr, "    [-E[uler]A[ngle]     EulerAngle          (XEYS      )Rot1                (0         )Rot2                (0         )Rot3                (0         )] :Optional  :EulerAngle: [degree]\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
